import React from "react";
import { useTheme } from "@mui/material";

const HeroBgSvg = () => {
  const theme = useTheme();
  return (
    <svg
      width="1240"
      height="504"
      viewBox="0 0 1240 504"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <mask
        id="mask0_472_1558"
        maskUnits="userSpaceOnUse"
        x="0"
        y="0"
        width="1240"
        height="504"
      >
        <rect width="1240" height="504" rx="20" fill="#E9F5EE" />
      </mask>
      <g mask="url(#mask0_472_1558)">
        <rect
          width="1240"
          height="504"
          rx="20"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M940.824 17.9871C938.255 17.3066 935.94 15.3559 934.629 12.743L928.605 0.749507C928.359 0.266899 927.929 -0.103066 927.448 -0.23189L917.103 -2.96755C916.623 -3.09637 916.138 -2.96679 915.797 -2.63981L907.581 5.59424C905.797 7.38063 903.197 8.0404 900.628 7.35994C896.101 6.16329 892.828 1.26494 893.355 -3.56931L896.406 -31.7049C897.078 -37.8888 902.347 -41.6665 908.153 -40.1318L943.741 -30.7316C949.547 -29.1969 953.719 -22.9195 953.047 -16.7356L949.996 11.4C949.472 16.2222 945.363 19.188 940.824 17.9871ZM917.228 -4.1561L927.573 -1.42042C928.405 -1.19822 929.152 -0.566092 929.572 0.26812L935.596 12.2616C936.724 14.5065 938.723 16.1951 940.951 16.7865C944.869 17.8188 948.421 15.2676 948.869 11.106L951.921 -17.0296C952.517 -22.5529 948.788 -28.1692 943.603 -29.5353L908.015 -38.9356C902.83 -40.3017 898.115 -36.9265 897.519 -31.4032L894.468 -3.26758C894.017 0.906086 896.834 5.139 900.741 6.16706C902.958 6.75414 905.206 6.18274 906.752 4.64505L914.968 -3.589C915.546 -4.16467 916.384 -4.38263 917.216 -4.16042L917.228 -4.1561Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M899.659 7.71812C895.275 6.06822 892.229 1.15017 892.758 -3.6971L895.81 -31.8383C896.148 -35.0015 897.63 -37.6561 899.976 -39.3484C902.32 -41.0286 905.246 -41.5271 908.204 -40.7522L943.797 -31.35C946.752 -30.5631 949.412 -28.5996 951.279 -25.8029C953.135 -23.0106 953.972 -19.7299 953.636 -16.5788L950.585 11.5624C950.311 14.0606 949.14 16.1692 947.288 17.514C945.426 18.8423 943.116 19.2345 940.768 18.624C938.01 17.8984 935.528 15.7938 934.128 13.0165L928.103 1.02069C927.956 0.718149 927.682 0.485242 927.388 0.413442L917.042 -2.32276C916.747 -2.39456 916.436 -2.32942 916.232 -2.12027L908.014 6.11542C906.106 8.02438 903.321 8.73237 900.564 8.00679C900.258 7.93067 899.969 7.83474 899.67 7.72244L899.659 7.71812ZM944.438 -28.6115C944.14 -28.7238 943.85 -28.8197 943.545 -28.8958L907.952 -38.2979C905.594 -38.9249 903.271 -38.5249 901.42 -37.1922C899.556 -35.8518 898.386 -33.7432 898.109 -31.2329L895.058 -3.09171C894.643 0.732178 897.221 4.62885 900.825 5.56894C902.867 6.1034 904.93 5.59198 906.34 4.17188L914.558 -4.06382C915.263 -4.77387 916.282 -5.02785 917.303 -4.76061L927.649 -2.02439C928.659 -1.76147 929.574 -0.987768 930.09 0.0388254L936.115 12.0347C937.156 14.1042 938.987 15.6517 941.029 16.1861C942.765 16.6445 944.485 16.355 945.855 15.3621C947.226 14.3693 948.096 12.8108 948.296 10.9614L951.348 -17.1799C951.625 -19.6901 950.953 -22.2839 949.485 -24.5012C948.203 -26.4272 946.438 -27.872 944.441 -28.6235L944.438 -28.6115Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M632.749 153.812C630.18 153.132 627.865 151.181 626.554 148.568L620.53 136.575C620.284 136.092 619.854 135.722 619.373 135.593L609.028 132.858C608.548 132.729 608.063 132.858 607.722 133.185L599.506 141.419C597.722 143.206 595.121 143.866 592.553 143.185C588.025 141.988 584.753 137.09 585.28 132.256L588.331 104.12C589.003 97.9364 594.272 94.1586 600.078 95.6934L635.666 105.094C641.472 106.628 645.644 112.906 644.972 119.09L641.921 147.225C641.397 152.047 637.288 155.013 632.749 153.812ZM609.153 131.669L619.498 134.405C620.33 134.627 621.077 135.259 621.497 136.093L627.521 148.087C628.648 150.332 630.648 152.02 632.876 152.612C636.794 153.644 640.346 151.093 640.794 146.931L643.845 118.796C644.441 113.272 640.713 107.656 635.528 106.29L599.94 96.8897C594.754 95.5235 590.04 98.8987 589.444 104.422L586.393 132.558C585.942 136.731 588.759 140.964 592.666 141.992C594.882 142.579 597.13 142.008 598.677 140.47L606.893 132.236C607.471 131.661 608.309 131.443 609.141 131.665L609.153 131.669Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M591.584 143.544C587.199 141.894 584.154 136.976 584.683 132.128L587.734 103.987C588.073 100.824 589.555 98.1691 591.901 96.4768C594.245 94.7966 597.171 94.2981 600.129 95.073L635.722 104.475C641.844 106.103 646.256 112.719 645.55 119.242L642.498 147.384C642.225 149.882 641.054 151.991 639.201 153.335C637.349 154.68 635.03 155.056 632.682 154.445C629.924 153.72 627.442 151.615 626.041 148.838L620.017 136.842C619.869 136.539 619.596 136.306 619.302 136.235L608.955 133.498C608.661 133.427 608.35 133.492 608.145 133.701L599.928 141.937C598.019 143.846 595.235 144.554 592.477 143.828C592.171 143.752 591.882 143.656 591.595 143.548L591.584 143.544ZM636.363 107.214C636.065 107.102 635.776 107.006 635.47 106.93L599.877 97.5272C595.008 96.2413 590.594 99.4185 590.034 104.592L586.982 132.734C586.782 134.583 587.271 136.51 588.366 138.145C589.458 139.791 591.014 140.936 592.75 141.394C594.792 141.929 596.855 141.418 598.265 139.997L606.483 131.762C607.186 131.064 608.207 130.798 609.228 131.065L619.574 133.801C620.584 134.064 621.499 134.838 622.015 135.864L628.04 147.86C629.081 149.93 630.912 151.477 632.954 152.012C636.544 152.96 639.805 150.623 640.222 146.787L643.273 118.646C643.55 116.135 642.881 113.529 641.41 111.324C640.117 109.394 638.363 107.953 636.366 107.202L636.363 107.214Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M602.699 122.063L600.662 121.544C600.337 121.465 600.097 121.104 600.131 120.763L601.581 107.784C601.614 107.442 601.923 107.229 602.249 107.309L604.286 107.828C604.611 107.907 604.851 108.267 604.818 108.609L603.367 121.587C603.334 121.929 603.025 122.142 602.699 122.063ZM601.398 120.44L602.248 120.658L603.55 108.931L602.7 108.713L601.398 120.44Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M600.488 122.114C599.883 121.889 599.476 121.223 599.548 120.572L600.985 107.638C601.018 107.297 601.184 107.006 601.444 106.831C601.703 106.656 602.016 106.595 602.336 106.687L604.354 107.204C605.021 107.383 605.498 108.089 605.414 108.79L603.977 121.725C603.944 122.065 603.778 122.356 603.519 122.531C603.272 122.711 602.947 122.767 602.624 122.688L600.606 122.171C600.606 122.171 600.521 122.14 600.485 122.126L600.488 122.114Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M607.986 117.671L596.615 114.778C596.316 114.707 596.097 114.379 596.128 114.068L596.343 112.122C596.374 111.811 596.658 111.616 596.957 111.687L608.33 114.568C608.629 114.639 608.848 114.967 608.817 115.279L608.602 117.224C608.571 117.536 608.287 117.731 607.989 117.659L607.986 117.671ZM597.289 113.782L607.563 116.387L607.654 115.576L597.38 112.971L597.289 113.782Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M596.416 115.339C595.855 115.133 595.478 114.519 595.547 113.918L595.762 111.955C595.793 111.64 595.948 111.371 596.189 111.209C596.418 111.042 596.72 110.99 597.02 111.062L608.422 113.981C609.043 114.133 609.483 114.795 609.404 115.442L609.189 117.406C609.11 118.053 608.552 118.451 607.933 118.287L596.531 115.368C596.531 115.368 596.453 115.34 596.419 115.327L596.416 115.339Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M621.451 121.172C619.985 120.789 618.932 119.198 619.106 117.638C619.27 116.074 620.602 115.122 622.066 115.518C623.533 115.901 624.586 117.492 624.411 119.052C624.248 120.616 622.915 121.568 621.451 121.172ZM621.93 116.712C621.092 116.487 620.329 117.038 620.23 117.931C620.131 118.825 620.74 119.736 621.579 119.961C622.417 120.186 623.18 119.635 623.279 118.742C623.377 117.848 622.769 116.937 621.93 116.712Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M621.057 121.693C619.438 121.082 618.319 119.269 618.516 117.482C618.62 116.564 619.045 115.781 619.732 115.293C620.42 114.806 621.274 114.656 622.135 114.89C623.917 115.379 625.213 117.298 625.003 119.211C624.899 120.129 624.474 120.912 623.787 121.4C623.099 121.887 622.245 122.037 621.383 121.803C621.279 121.764 621.161 121.732 621.057 121.693ZM621.862 117.343C621.343 117.2 620.872 117.546 620.821 118.091C620.791 118.355 620.859 118.629 621.02 118.874C621.184 119.106 621.397 119.278 621.645 119.346C622.164 119.489 622.635 119.143 622.686 118.598C622.751 118.046 622.358 117.478 621.86 117.355L621.862 117.343Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M634.084 123.751C632.618 123.368 631.564 121.777 631.739 120.217C631.902 118.653 633.235 117.701 634.699 118.097C636.166 118.48 637.219 120.071 637.044 121.631C636.881 123.195 635.548 124.147 634.084 123.751ZM634.563 119.291C633.724 119.066 632.961 119.617 632.863 120.51C632.764 121.404 633.373 122.316 634.211 122.54C635.05 122.765 635.813 122.215 635.912 121.321C636.01 120.427 635.402 119.516 634.563 119.291Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M633.689 124.272C632.071 123.661 630.951 121.849 631.149 120.062C631.357 118.161 632.973 116.988 634.768 117.469C636.572 117.967 637.846 119.877 637.635 121.79C637.531 122.708 637.106 123.492 636.419 123.979C635.731 124.467 634.877 124.616 634.016 124.382C633.912 124.343 633.794 124.312 633.689 124.272ZM634.495 119.922C633.976 119.779 633.505 120.125 633.454 120.67C633.424 120.934 633.491 121.209 633.652 121.453C633.814 121.697 634.03 121.858 634.278 121.925C634.525 121.992 634.77 121.954 634.975 121.808C635.168 121.658 635.3 121.446 635.33 121.182C635.395 120.63 635.013 120.066 634.504 119.939L634.495 119.922Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M628.871 115.067C627.404 114.682 626.349 113.091 626.522 111.533C626.685 109.97 628.017 109.02 629.482 109.418C630.95 109.803 632.004 111.394 631.831 112.952C631.657 114.51 630.336 115.464 628.871 115.067ZM629.347 110.611C628.508 110.385 627.745 110.934 627.647 111.827C627.549 112.72 628.158 113.632 628.997 113.858C629.836 114.083 630.599 113.534 630.697 112.641C630.795 111.748 630.186 110.837 629.347 110.611Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M628.476 115.584C626.857 114.971 625.735 113.159 625.931 111.373C626.034 110.456 626.459 109.674 627.146 109.187C627.834 108.701 628.688 108.553 629.55 108.787C631.335 109.266 632.631 111.198 632.422 113.109C632.319 114.026 631.894 114.809 631.207 115.295C630.519 115.781 629.665 115.929 628.803 115.695C628.699 115.655 628.58 115.624 628.476 115.584ZM629.278 111.239C628.759 111.094 628.288 111.44 628.238 111.984C628.208 112.248 628.276 112.522 628.437 112.767C628.601 112.999 628.815 113.172 629.063 113.239C629.582 113.383 630.053 113.038 630.103 112.494C630.168 111.942 629.786 111.378 629.276 111.251L629.278 111.239Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M626.666 129.856C625.198 129.471 624.144 127.88 624.317 126.322C624.479 124.759 625.812 123.809 627.277 124.207C628.744 124.592 629.799 126.183 629.626 127.741C629.463 129.304 628.131 130.253 626.666 129.856ZM627.142 125.4C626.303 125.174 625.54 125.723 625.442 126.616C625.344 127.509 625.953 128.421 626.792 128.646C627.631 128.872 628.394 128.323 628.492 127.43C628.59 126.537 627.981 125.626 627.142 125.4Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M626.281 130.38C624.662 129.767 623.541 127.955 623.736 126.169C623.84 125.252 624.264 124.47 624.951 123.983C625.639 123.497 626.493 123.349 627.355 123.583C629.143 124.05 630.436 125.994 630.227 127.905C630.124 128.822 629.699 129.605 629.012 130.091C628.325 130.577 627.47 130.726 626.608 130.491C626.504 130.451 626.386 130.42 626.281 130.38ZM627.084 126.035C626.565 125.89 626.094 126.236 626.043 126.78C626.013 127.044 626.081 127.318 626.242 127.563C626.406 127.795 626.62 127.968 626.868 128.035C627.387 128.179 627.858 127.834 627.909 127.29C627.973 126.738 627.591 126.174 627.081 126.047L627.084 126.035Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M617.574 130.613L611.448 129.034C611.147 128.96 610.927 128.626 610.958 128.308L611.162 126.486C611.193 126.169 611.479 125.971 611.78 126.044L617.905 127.623C618.206 127.697 618.427 128.031 618.396 128.349L618.191 130.171C618.16 130.488 617.875 130.686 617.574 130.613ZM612.14 128.011L617.158 129.308L617.236 128.654L612.219 127.357L612.14 128.011Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M611.266 129.614C610.7 129.404 610.32 128.779 610.388 128.166L610.594 126.33C610.673 125.671 611.234 125.267 611.858 125.435L618.004 127.027C618.627 127.195 619.073 127.857 618.995 128.517L618.789 130.353C618.758 130.673 618.602 130.947 618.36 131.112C618.117 131.277 617.824 131.334 617.525 131.248L611.379 129.656C611.379 129.656 611.3 129.627 611.266 129.614Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M619.03 100.143C618.7 100.067 618.459 99.7058 618.495 99.3615L619.542 90.3987C619.578 90.0544 619.892 89.8373 620.222 89.9141C620.552 89.9909 620.792 90.3517 620.757 90.696L619.709 99.6589C619.674 100.003 619.36 100.22 619.03 100.143Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M618.841 100.743C618.234 100.522 617.829 99.8563 617.893 99.1965L618.921 90.2795C618.956 89.937 619.124 89.6429 619.385 89.4643C619.647 89.2858 619.961 89.2224 620.285 89.2988C620.954 89.4731 621.429 90.1784 621.342 90.8844L620.314 99.8014C620.279 100.144 620.11 100.438 619.849 100.617C619.588 100.795 619.273 100.859 618.95 100.782C618.95 100.782 618.865 100.751 618.828 100.738L618.841 100.743Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M866.594 229.644C866.523 229.618 866.455 229.579 866.402 229.532C857.642 222.104 853.273 209.889 855.511 199.152C857.748 188.416 866.212 181.038 876.555 180.811C876.694 180.81 876.835 180.863 876.954 180.962C885.714 188.39 890.109 200.601 887.869 211.35C885.629 222.099 877.167 229.464 866.801 229.683C866.737 229.685 866.664 229.671 866.594 229.644ZM876.507 182.071C866.728 182.391 858.759 189.396 856.638 199.577C854.516 209.758 858.617 221.314 866.848 228.423C876.637 228.12 884.62 221.106 886.742 210.925C888.863 200.744 884.753 189.172 876.507 182.071Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M866.468 230.253C866.327 230.2 866.192 230.123 866.073 230.025C857.115 222.416 852.642 209.927 854.932 198.935C857.223 187.944 865.881 180.405 876.463 180.163C876.744 180.149 877.037 180.259 877.284 180.472C886.245 188.068 890.741 200.567 888.448 211.571C886.155 222.574 877.496 230.114 866.894 230.334C866.755 230.335 866.609 230.307 866.468 230.253ZM876.367 182.748C866.952 183.163 859.278 189.983 857.232 199.802C855.186 209.622 859.107 220.813 866.99 227.749C876.414 227.35 884.102 220.523 886.148 210.703C888.194 200.884 884.276 189.681 876.367 182.748Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M877.546 180.812C877.479 180.788 877.414 180.752 877.363 180.709C876.166 179.735 874.911 178.863 873.615 178.124C873.368 177.986 873.228 177.688 873.285 177.425C873.343 177.162 873.583 177.001 873.85 177.047C876.766 177.541 879.558 178.546 882.237 180.067C882.484 180.205 882.624 180.503 882.567 180.766C882.509 181.03 882.269 181.19 882.003 181.144C880.574 180.901 879.137 180.804 877.743 180.846C877.671 180.844 877.613 180.836 877.546 180.812ZM876.783 178.894C877.127 179.141 877.454 179.408 877.796 179.666C878.183 179.657 878.579 179.664 878.973 179.682C878.254 179.387 877.528 179.125 876.795 178.898L876.783 178.894Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M877.419 181.411C877.285 181.362 877.155 181.29 877.042 181.198C875.872 180.234 874.643 179.374 873.373 178.65C872.866 178.365 872.588 177.75 872.706 177.205C872.824 176.659 873.308 176.322 873.855 176.42C876.829 176.925 879.732 177.981 882.475 179.554C882.98 179.85 883.26 180.453 883.142 180.999C883.024 181.545 882.54 181.882 881.994 181.784C880.596 181.538 879.19 181.441 877.827 181.484C877.693 181.485 877.554 181.459 877.419 181.411ZM874.22 177.693C874.081 177.667 873.941 177.641 873.813 177.62C874.334 177.897 874.858 178.213 875.368 178.536L874.232 177.697L874.22 177.693ZM881.747 180.404L880.524 180.36C881.033 180.408 881.538 180.478 882.051 180.565C881.955 180.505 881.846 180.453 881.747 180.404Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M865.242 232.348C863.857 231.85 862.477 231.217 861.127 230.447C860.88 230.308 860.74 230.011 860.798 229.748C860.855 229.484 861.095 229.323 861.362 229.37C862.769 229.605 864.191 229.709 865.611 229.664C865.743 229.662 865.878 229.711 865.99 229.801C867.165 230.767 868.431 231.643 869.75 232.39C869.997 232.528 870.137 232.825 870.079 233.089C870.022 233.352 869.782 233.513 869.515 233.466C868.05 233.223 866.616 232.843 865.231 232.344L865.242 232.348ZM864.392 230.831C865.111 231.127 865.837 231.389 866.57 231.616C866.227 231.368 865.888 231.098 865.561 230.832C865.173 230.841 864.777 230.834 864.381 230.827L864.392 230.831Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M865.115 232.95C863.691 232.433 862.275 231.767 860.887 230.974C860.38 230.69 860.102 230.075 860.22 229.53C860.337 228.984 860.821 228.646 861.368 228.745C862.744 228.982 864.138 229.076 865.524 229.041C865.791 229.038 866.071 229.14 866.298 229.322C867.445 230.278 868.685 231.142 869.989 231.879C870.496 232.164 870.774 232.779 870.656 233.324C870.539 233.87 870.054 234.208 869.508 234.109C868.015 233.854 866.527 233.464 865.104 232.946L865.115 232.95ZM862.863 230.165C862.353 230.118 861.838 230.043 861.324 229.956C861.434 230.009 861.53 230.069 861.639 230.121L862.863 230.165ZM868.008 231.986L869.144 232.825C869.284 232.85 869.412 232.872 869.552 232.898C869.031 232.621 868.507 232.305 868.008 231.986Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M869.69 231.943C869.69 231.943 869.619 231.917 869.595 231.908C868.12 231.046 866.7 230.044 865.392 228.936C865.184 228.764 865.088 228.486 865.141 228.237C865.193 227.987 865.383 227.816 865.627 227.814C875.651 227.584 883.858 220.475 886.033 210.113C888.208 199.751 883.979 187.974 875.49 180.83C875.282 180.658 875.187 180.38 875.239 180.131C875.291 179.882 875.481 179.711 875.726 179.708C877.286 179.673 878.89 179.803 880.474 180.086C880.548 180.1 880.607 180.122 880.676 180.162C892.177 186.9 898.591 201.054 895.91 213.822C893.23 226.591 882.253 234.237 869.792 232.008C869.757 231.995 869.721 231.982 869.697 231.973L869.69 231.943ZM867.32 228.985C868.162 229.623 869.041 230.207 869.944 230.734C881.785 232.798 892.212 225.51 894.764 213.353C897.316 201.195 891.244 187.734 880.323 181.294C879.346 181.116 878.365 181.018 877.4 180.967C885.428 188.53 889.337 200.186 887.169 210.511C885.002 220.835 877.126 228.082 867.323 228.973L867.32 228.985Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M869.576 232.553L869.356 232.444C867.87 231.578 866.419 230.551 865.07 229.401C864.655 229.057 864.454 228.485 864.561 227.974C864.668 227.463 865.06 227.126 865.551 227.108C875.317 226.893 883.313 219.955 885.433 209.849C887.554 199.743 883.431 188.28 875.174 181.305C874.759 180.961 874.558 180.389 874.665 179.878C874.773 179.367 875.164 179.03 875.655 179.012C877.252 178.978 878.88 179.104 880.512 179.392C880.648 179.417 880.791 179.47 880.929 179.548C892.692 186.439 899.246 200.921 896.505 213.981C893.765 227.04 882.532 234.863 869.801 232.583L869.594 232.533L869.576 232.553ZM869.05 229.44C869.4 229.665 869.751 229.89 870.092 230.098C881.571 232.044 891.682 224.93 894.155 213.141C896.629 201.353 890.759 188.255 880.194 181.948C879.81 181.885 879.426 181.821 879.048 181.788C886.455 189.574 889.858 200.74 887.758 210.746C885.659 220.753 878.408 227.93 869.05 229.44ZM875.87 180.369C875.87 180.369 875.832 180.368 875.818 180.376C876.046 180.57 876.263 180.758 876.48 180.947L875.87 180.369Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M862.89 230.712C862.89 230.712 862.818 230.685 862.782 230.672C851.242 223.963 844.844 209.761 847.584 196.896C850.323 184.032 861.387 176.27 873.908 178.436C874.232 178.487 874.482 178.824 874.473 179.172C874.463 179.521 874.181 179.756 873.857 179.704C861.907 177.641 851.345 185.046 848.731 197.319C846.117 209.593 852.216 223.144 863.24 229.553C863.537 229.731 863.673 230.12 863.556 230.429C863.447 230.7 863.162 230.826 862.887 230.724L862.89 230.712Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M862.75 231.32L862.528 231.211C850.743 224.355 844.208 209.825 847.005 196.681C849.802 183.537 861.121 175.584 873.907 177.799C874.231 177.851 874.528 178.028 874.736 178.322C874.958 178.607 875.066 178.945 875.057 179.293C875.047 179.642 874.906 179.942 874.671 180.139C874.435 180.337 874.133 180.428 873.812 180.364C862.181 178.345 851.892 185.568 849.346 197.532C846.8 209.495 852.741 222.71 863.474 228.946C863.77 229.124 863.996 229.396 864.119 229.726C864.241 230.056 864.241 230.421 864.114 230.713C863.893 231.268 863.313 231.514 862.752 231.307L862.75 231.32Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M865.258 232.485C864.913 232.37 864.71 232.011 864.792 231.663L877.361 178.442C877.443 178.094 877.774 177.912 878.119 178.027C878.463 178.141 878.666 178.501 878.584 178.849L866.015 232.07C865.933 232.418 865.602 232.599 865.258 232.485Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M865.177 233.1C864.496 232.872 864.074 232.119 864.236 231.424L876.669 178.26C876.831 177.565 877.518 177.184 878.199 177.413C878.88 177.642 879.302 178.394 879.139 179.09L866.707 232.254C866.544 232.949 865.857 233.329 865.177 233.1Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M894.303 213.339L848.814 198.236C848.517 198.137 848.341 197.826 848.412 197.524C848.484 197.223 848.77 197.065 849.068 197.164L894.556 212.267C894.854 212.366 895.03 212.677 894.958 212.978C894.887 213.28 894.6 213.437 894.303 213.339Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M894.201 213.98L848.672 198.735C848.076 198.535 847.708 197.877 847.85 197.268C847.993 196.66 848.595 196.327 849.19 196.526L894.719 211.771C895.315 211.971 895.683 212.629 895.541 213.238C895.398 213.846 894.796 214.18 894.201 213.98Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M726.015 151.786C724.539 150.491 726.179 148.058 727.644 149.348C729.121 150.643 727.48 153.076 726.015 151.786ZM726.015 151.786C727.48 153.076 729.118 150.655 727.644 149.348C726.179 148.058 724.542 150.479 726.015 151.786ZM727.869 156.906L734.191 147.479C734.374 147.206 734.316 146.807 734.057 146.593L695.067 112.138C694.811 111.911 694.46 111.949 694.288 112.226L687.965 121.653C687.783 121.926 687.841 122.325 688.1 122.539L702.177 134.984C702.433 135.21 702.785 135.173 702.956 134.896C703.139 134.622 703.081 134.223 702.822 134.01L689.194 121.967L694.861 113.511L732.941 147.157L727.274 155.613L712.692 142.731C712.436 142.505 712.085 142.543 711.914 142.82C711.742 143.097 711.789 143.493 712.048 143.706L727.079 156.99C727.335 157.217 727.686 157.179 727.857 156.902L727.869 156.906ZM701.171 187.472L723.474 154.197C723.656 153.924 723.598 153.524 723.339 153.311C723.083 153.085 722.732 153.122 722.561 153.4L700.584 186.196L670.307 159.443L692.283 126.646C692.466 126.373 692.408 125.974 692.149 125.76C691.893 125.534 691.542 125.572 691.37 125.849L669.068 159.125C668.885 159.398 668.943 159.797 669.202 160.011L700.39 187.574C700.646 187.8 700.997 187.762 701.168 187.485L701.171 187.472ZM690.156 177.452L719.023 134.376C719.206 134.103 719.147 133.704 718.888 133.49L709.18 124.92C708.924 124.694 708.573 124.732 708.401 125.009L679.534 168.085C679.351 168.358 679.41 168.757 679.669 168.971L689.377 177.541C689.633 177.767 689.984 177.729 690.156 177.452ZM708.988 126.286L717.783 134.058L689.572 176.163L680.777 168.39L708.988 126.286ZM713.742 129.311C714.003 129.512 714.348 129.445 714.511 129.151C717.47 123.805 716.802 120.133 715.712 117.975C714.283 115.142 711.563 113.772 709.633 113.695C705.655 113.528 705.451 121.028 705.452 121.353C705.448 121.703 705.688 122.005 705.997 122.047C706.309 122.076 706.56 121.827 706.575 121.481C706.577 121.414 706.805 114.856 709.681 114.97C711.345 115.033 713.614 116.284 714.752 118.554C715.678 120.397 716.228 123.608 713.553 128.446C713.407 128.719 713.474 129.081 713.707 129.299C713.719 129.303 713.73 129.307 713.75 129.328L713.742 129.311ZM715.51 130.168C718.891 125.959 721.74 125.753 723.527 126.306C725.726 126.991 727.368 129.197 727.847 131.016C728.677 134.178 723.218 136.108 723.164 136.13C722.873 136.229 722.722 136.581 722.831 136.917C722.94 137.253 723.264 137.449 723.555 137.35C723.821 137.255 730.086 135.11 728.922 130.749C728.363 128.63 726.506 125.957 723.757 125.103C721.674 124.445 718.398 124.648 714.662 129.3C714.459 129.552 714.495 129.943 714.723 130.187C714.734 130.191 714.743 130.207 714.763 130.228C714.999 130.433 715.319 130.425 715.519 130.185L715.51 130.168ZM691.182 152.8L695.917 145.731C696.1 145.458 696.042 145.059 695.783 144.845L685.483 135.741C685.227 135.515 684.876 135.553 684.704 135.83L679.969 142.898C679.786 143.171 679.844 143.571 680.103 143.784L690.403 152.889C690.659 153.115 691.01 153.077 691.182 152.8ZM685.291 137.106L694.681 145.4L690.589 151.494L681.2 143.2L685.291 137.106ZM712.041 171.221L716.776 164.153C716.959 163.88 716.901 163.48 716.642 163.267L705.736 153.637C705.48 153.411 705.129 153.448 704.957 153.726L700.222 160.794C700.039 161.067 700.097 161.467 700.356 161.68L711.262 171.31C711.518 171.536 711.869 171.499 712.041 171.221ZM705.555 155.006L715.548 163.839L711.457 169.933L701.464 161.1L705.555 155.006ZM728.31 157.292L734.632 147.866C734.995 147.332 734.878 146.533 734.378 146.085L695.387 111.629C694.887 111.181 694.185 111.257 693.822 111.79L687.499 121.217C687.136 121.75 687.253 122.549 687.753 122.997L701.831 135.443C702.332 135.891 703.034 135.816 703.397 135.282C703.76 134.748 703.643 133.949 703.142 133.501L689.975 121.865L694.986 114.381L732.156 147.217L727.145 154.702L713.024 142.227C712.524 141.779 711.821 141.854 711.458 142.388C711.095 142.922 711.212 143.721 711.713 144.169L726.744 157.453C727.244 157.901 727.947 157.826 728.31 157.292ZM726.938 156.075C727.194 156.301 727.546 156.264 727.717 155.986L733.384 147.531C733.567 147.258 733.509 146.859 733.25 146.645L695.17 112.999C694.914 112.773 694.563 112.811 694.391 113.088L688.724 121.543C688.541 121.816 688.6 122.216 688.859 122.429L688.398 122.022L694.72 112.596L733.711 147.052L727.388 156.478L712.357 143.194L726.938 156.075ZM701.612 187.859L723.914 154.583C724.277 154.049 724.161 153.251 723.66 152.803C723.159 152.354 722.457 152.43 722.094 152.964L700.447 185.268L671.08 159.325L692.727 127.02C693.09 126.486 692.973 125.688 692.472 125.239C691.972 124.791 691.269 124.867 690.906 125.401L668.604 158.676C668.241 159.21 668.358 160.009 668.858 160.457L700.046 188.02C700.547 188.468 701.249 188.392 701.612 187.859ZM669.964 159.889L700.241 186.642C700.497 186.868 700.848 186.83 701.02 186.553L722.996 153.757L700.693 187.032L669.506 159.469L669.835 158.978C669.652 159.251 669.71 159.65 669.969 159.864L669.964 159.889ZM690.599 177.826L719.467 134.75C719.83 134.216 719.713 133.417 719.212 132.969L709.503 124.4C709.003 123.952 708.301 124.027 707.938 124.561L679.07 167.636C678.707 168.17 678.824 168.969 679.325 169.417L689.033 177.987C689.534 178.435 690.236 178.359 690.599 177.826ZM680.442 168.853L689.237 176.625C689.493 176.852 689.844 176.814 690.016 176.537L718.227 134.432C718.41 134.159 718.351 133.759 718.093 133.546L718.553 133.953L689.686 177.028L679.981 168.446L680.31 167.954C680.127 168.228 680.186 168.627 680.444 168.841L680.442 168.853ZM709.114 127.155L716.988 134.114L689.42 175.244L681.547 168.285L709.114 127.155ZM709.309 125.777C709.053 125.551 708.702 125.589 708.53 125.866L708.859 125.374L709.32 125.781L709.309 125.777ZM713.449 129.802C713.699 129.999 714.003 130.066 714.297 130.008C714.592 129.951 714.829 129.764 714.989 129.483C718.088 123.889 717.353 119.964 716.196 117.674C714.646 114.609 711.693 113.128 709.619 113.041C705.13 112.855 704.898 120.927 704.897 121.264C704.877 121.96 705.379 122.571 705.988 122.638C706.286 122.676 706.577 122.577 706.786 122.354C707.006 122.134 707.121 121.837 707.133 121.503C707.174 119.936 707.746 115.473 709.698 115.558C711.191 115.614 713.242 116.747 714.271 118.789C715.121 120.483 715.613 123.457 713.07 128.031C712.769 128.56 712.909 129.313 713.381 129.724C713.392 129.728 713.443 129.773 713.463 129.794L713.449 129.802ZM714.022 128.762C716.284 124.683 716.333 121.644 715.748 119.584C716.333 121.644 716.284 124.683 714.034 128.766L713.696 129.241L714.025 128.749L714.022 128.762ZM715.155 118.116C713.929 115.801 711.625 114.483 709.862 114.318C710.979 114.416 712.327 114.962 713.494 115.998C714.128 116.561 714.706 117.267 715.155 118.116ZM715.932 130.588C719.14 126.602 721.76 126.382 723.408 126.899C725.388 127.521 726.871 129.507 727.303 131.148C727.868 133.296 724.27 135.061 722.957 135.515C722.375 135.714 722.086 136.41 722.293 137.078C722.512 137.751 723.148 138.139 723.731 137.94C726.347 137.07 730.483 134.535 729.448 130.584C728.843 128.287 726.838 125.398 723.862 124.464C721.629 123.766 718.137 123.947 714.229 128.821C714.041 129.066 713.946 129.383 713.97 129.717C713.994 130.05 714.132 130.369 714.351 130.595C714.362 130.599 714.422 130.661 714.431 130.678C714.903 131.089 715.56 131.051 715.932 130.588ZM723.802 125.727C726.084 126.537 727.677 128.684 728.275 130.519C727.881 129.311 727.059 127.992 725.93 127.01C725.304 126.463 724.585 126.005 723.802 125.727ZM691.625 153.173L696.361 146.105C696.724 145.571 696.607 144.772 696.107 144.324L685.806 135.22C685.306 134.772 684.603 134.847 684.24 135.381L679.505 142.45C679.142 142.984 679.259 143.782 679.759 144.23L690.06 153.335C690.56 153.783 691.262 153.707 691.625 153.173ZM680.865 143.662L690.254 151.957C690.51 152.183 690.862 152.145 691.033 151.868L695.124 145.774C695.307 145.501 695.249 145.102 694.99 144.888L695.451 145.295L690.715 152.364L680.415 143.26L680.744 142.768C680.561 143.041 680.62 143.44 680.879 143.654L680.865 143.662ZM685.405 137.972L693.882 145.469L690.446 150.592L681.97 143.094L685.405 137.972ZM685.6 136.594C685.344 136.368 684.993 136.405 684.822 136.683L685.151 136.191L685.612 136.598L685.6 136.594ZM712.482 171.608L717.217 164.539C717.58 164.005 717.463 163.207 716.963 162.759L706.057 153.128C705.556 152.68 704.854 152.756 704.491 153.29L699.755 160.358C699.392 160.892 699.509 161.691 700.01 162.139L710.916 171.769C711.416 172.217 712.119 172.142 712.482 171.608ZM701.126 161.575L711.119 170.408C711.375 170.634 711.726 170.596 711.898 170.319L715.989 164.225C716.172 163.952 716.114 163.553 715.855 163.339L716.316 163.746L711.58 170.815L700.674 161.184L701.003 160.693C700.82 160.966 700.879 161.365 701.138 161.579L701.126 161.575ZM705.667 155.884L714.738 163.903L711.303 169.026L702.231 161.007L705.667 155.884ZM705.862 154.506C705.606 154.28 705.255 154.318 705.083 154.595L705.412 154.103L705.873 154.51L705.862 154.506Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M530.342 -0.191978C530.271 -0.218533 530.203 -0.257427 530.15 -0.304237C521.39 -7.73249 517.021 -19.9475 519.259 -30.684C521.496 -41.4204 529.96 -48.798 540.303 -49.0254C540.442 -49.0261 540.583 -48.9729 540.702 -48.8749C549.462 -41.4466 553.857 -29.2351 551.617 -18.4863C549.377 -7.73758 540.915 -0.372319 530.549 -0.15376C530.485 -0.151208 530.412 -0.165424 530.342 -0.191978ZM540.256 -47.7654C530.476 -47.4455 522.507 -40.4402 520.386 -30.2591C518.264 -20.078 522.365 -8.52289 530.596 -1.41372C540.385 -1.71688 548.368 -8.73013 550.49 -18.9112C552.611 -29.0923 548.501 -40.6642 540.256 -47.7654Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M530.216 0.416215C530.075 0.363125 529.939 0.285354 529.823 0.175005C520.862 -7.42088 516.392 -19.9232 518.682 -30.9147C520.973 -41.9061 529.632 -49.4455 540.213 -49.6875C540.506 -49.6967 540.787 -49.5906 541.034 -49.3778C550.007 -41.7775 554.491 -29.283 552.198 -18.2792C549.906 -7.27543 541.247 0.263934 530.645 0.484703C530.505 0.485382 530.359 0.456959 530.218 0.403868L530.216 0.416215ZM540.115 -47.0901C530.7 -46.6745 523.026 -39.8547 520.98 -30.0352C518.934 -20.2157 522.855 -9.02478 530.738 -2.08801C540.162 -2.48678 547.85 -9.3145 549.896 -19.134C551.942 -28.9536 548.023 -40.1568 540.115 -47.0901Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M528.993 2.50332C527.608 2.00471 526.228 1.37207 524.878 0.601961C524.631 0.463659 524.491 0.166211 524.549 -0.0972439C524.606 -0.360699 524.846 -0.521436 525.113 -0.47477C526.52 -0.240224 527.942 -0.135698 529.362 -0.180691C529.494 -0.182278 529.629 -0.134027 529.741 -0.0439774C530.916 0.922444 532.182 1.79844 533.501 2.54503C533.748 2.68334 533.888 2.98079 533.83 3.24424C533.773 3.5077 533.533 3.66843 533.266 3.62176C531.801 3.37857 530.367 2.99791 528.982 2.4993L528.993 2.50332ZM528.143 0.98672C528.862 1.28245 529.588 1.54382 530.321 1.77082C529.978 1.52358 529.639 1.25344 529.312 0.987311C528.924 0.996093 528.528 0.989396 528.132 0.982701L528.143 0.98672Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M528.866 3.10014C527.454 2.58648 526.026 1.91716 524.638 1.12417C524.131 0.839656 523.853 0.224904 523.971 -0.320913C524.088 -0.86673 524.573 -1.20425 525.119 -1.10555C526.495 -0.868374 527.89 -0.774638 529.275 -0.809258C529.545 -0.824088 529.825 -0.722166 530.06 -0.523883C531.219 0.436149 532.459 1.30043 533.741 2.02944C534.248 2.31395 534.526 2.92868 534.408 3.4745C534.29 4.02032 533.806 4.35785 533.259 4.25915C531.755 4.00036 530.279 3.61381 528.855 3.09607L528.866 3.10014ZM526.603 0.310715C526.093 0.263161 525.578 0.188302 525.075 0.105908C525.185 0.158288 525.281 0.218201 525.391 0.270581L526.603 0.310715ZM531.739 2.1157L532.896 2.97468C533.035 3.00037 533.175 3.02605 533.314 3.05175C532.783 2.7707 532.258 2.45481 531.739 2.1157Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M533.437 2.11226C533.437 2.11226 533.366 2.08554 533.342 2.07663C531.867 1.21523 530.447 0.213101 529.139 -0.895004C528.931 -1.06692 528.835 -1.34481 528.888 -1.5942C528.94 -1.84358 529.13 -2.01457 529.374 -2.01722C539.398 -2.24703 547.605 -9.35653 549.78 -19.7184C551.955 -30.0802 547.726 -41.857 539.237 -49.0009C539.029 -49.1729 538.934 -49.4507 538.986 -49.7001C539.038 -49.9495 539.228 -50.1205 539.473 -50.1232C541.033 -50.1578 542.637 -50.0285 544.221 -49.7451C544.295 -49.7308 544.354 -49.7086 544.423 -49.6694C555.924 -42.9313 562.338 -28.7772 559.658 -16.0088C556.977 -3.24037 546 4.40595 533.539 2.1773C533.504 2.16394 533.468 2.15057 533.444 2.14166L533.437 2.11226ZM531.067 -0.845844C531.909 -0.208053 532.788 0.376306 533.691 0.902772C545.532 2.9666 555.959 -4.32082 558.511 -16.4782C561.063 -28.6356 554.991 -42.0969 544.07 -48.5374C543.093 -48.7147 542.112 -48.8128 541.147 -48.8645C549.176 -41.3011 553.084 -29.6446 550.916 -19.3201C548.749 -8.9957 540.873 -1.74901 531.07 -0.858308L531.067 -0.845844Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M533.324 2.71881L533.122 2.64313C531.618 1.74399 530.166 0.716684 528.815 -0.421C528.402 -0.77708 528.199 -1.33699 528.306 -1.84791C528.413 -2.35882 528.805 -2.69615 529.296 -2.7139C539.062 -2.92845 547.046 -9.87152 549.166 -19.9777C551.287 -30.0838 547.164 -41.5462 538.907 -48.5219C538.492 -48.8655 538.291 -49.4378 538.399 -49.9488C538.506 -50.4597 538.897 -50.797 539.388 -50.8148C540.986 -50.8484 542.625 -50.7183 544.246 -50.4343C544.382 -50.4102 544.524 -50.3568 544.662 -50.2784C556.425 -43.3879 562.979 -28.9052 560.239 -15.8457C557.499 -2.7862 546.265 5.03692 533.534 2.75711L533.327 2.70635L533.324 2.71881ZM532.798 -0.394851C533.148 -0.169619 533.498 0.0556223 533.839 0.263938C545.319 2.20984 555.43 -4.90484 557.903 -16.6933C560.377 -28.4817 554.507 -41.5794 543.942 -47.8868C543.558 -47.95 543.174 -48.0132 542.796 -48.0471C550.203 -40.2606 553.606 -29.0947 551.506 -19.0883C549.407 -9.08179 542.155 -1.90455 532.798 -0.394851ZM539.618 -49.4653C539.618 -49.4653 539.58 -49.4662 539.565 -49.4582C539.794 -49.265 540.011 -49.0763 540.228 -48.8876L539.618 -49.4653Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M526.64 0.875664C526.64 0.875664 526.568 0.849215 526.532 0.83599C514.992 -5.87279 508.594 -20.0753 511.334 -32.9397C514.073 -45.804 525.137 -53.5658 537.658 -51.4004C537.982 -51.3486 538.232 -51.0122 538.223 -50.6636C538.213 -50.3149 537.931 -50.0802 537.607 -50.132C525.657 -52.1951 515.095 -44.7904 512.481 -32.5165C509.867 -20.2425 515.966 -6.69243 526.99 -0.282538C527.287 -0.105104 527.423 0.283909 527.306 0.592909C527.197 0.864223 526.912 0.989632 526.637 0.888238L526.64 0.875664Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M526.498 1.47918L526.295 1.40429C514.491 -5.48504 507.965 -19.9987 510.764 -33.155C513.564 -46.3113 524.881 -54.2517 537.667 -52.0367C537.979 -51.9894 538.287 -51.8077 538.495 -51.5143C538.718 -51.2291 538.826 -50.8912 538.816 -50.5428C538.794 -49.8334 538.228 -49.3518 537.569 -49.4597C525.938 -51.4784 515.649 -44.2552 513.103 -32.2916C510.558 -20.3279 516.498 -7.11364 527.231 -0.876925C527.528 -0.69962 527.753 -0.426966 527.876 -0.0972612C527.999 0.232446 527.998 0.597823 527.872 0.889639C527.651 1.44442 527.07 1.69063 526.51 1.48359L526.498 1.47918Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M529.009 2.63629C528.664 2.52184 528.461 2.16215 528.543 1.81413L541.112 -51.4067C541.194 -51.7547 541.525 -51.9364 541.87 -51.8219C542.214 -51.7075 542.417 -51.3478 542.335 -50.9998L529.766 2.22107C529.684 2.56909 529.353 2.75074 529.009 2.63629Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M528.928 3.25179C528.247 3.02313 527.825 2.27029 527.987 1.575L540.42 -51.5888C540.582 -52.2841 541.269 -52.6643 541.95 -52.4356C542.631 -52.207 543.053 -51.4541 542.89 -50.7588L530.458 2.40495C530.295 3.10023 529.608 3.48044 528.928 3.25179Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1177.34 46.1624C1177.9 48.2127 1178.03 50.3625 1177.74 52.3869L1177.1 56.7897L1175.85 57.0925C1173.74 57.6068 1172.55 59.9927 1173.21 62.4014L1181.91 94.2224C1182.35 95.8226 1183.5 97.0487 1184.84 97.5333C1185.52 97.7799 1186.24 97.839 1186.95 97.6647L1187.89 97.4408L1191.21 101.635C1192.5 103.278 1193.49 105.225 1194.04 107.258L1196.14 114.934C1196.35 115.697 1196.81 116.347 1197.42 116.773C1197.62 116.911 1197.83 117.015 1198.05 117.094C1198.5 117.257 1198.97 117.295 1199.42 117.175L1206.06 115.553C1206.06 115.553 1206.18 115.516 1206.23 115.491C1206.28 115.483 1206.34 115.478 1206.41 115.462L1213.05 113.84C1214.42 113.504 1215.19 111.951 1214.76 110.38L1212.66 102.704C1212.1 100.654 1211.97 98.5162 1212.26 96.4794L1213.01 91.2935L1214.85 90.8413C1216.96 90.327 1218.15 87.9411 1217.49 85.5325L1214.71 75.3727L1215.6 75.157C1216.16 75.0243 1216.63 74.6415 1216.9 74.0794C1217.17 73.5298 1217.22 72.8633 1217.05 72.2215L1214.86 64.2163C1214.5 62.8869 1213.25 62.0274 1212.09 62.3219L1211.2 62.5376L1208.77 53.7072C1208.11 51.2985 1205.85 49.7505 1203.74 50.2649L1201.6 50.7834L1198.78 47.2142C1197.49 45.5714 1196.5 43.6249 1195.95 41.5912L1193.85 33.9152C1193.42 32.3441 1191.94 31.3386 1190.57 31.6745L1183.93 33.2964C1183.93 33.2964 1183.81 33.3338 1183.75 33.3545C1183.7 33.3628 1183.64 33.3669 1183.57 33.371L1176.93 34.9929C1176.27 35.1546 1175.72 35.604 1175.39 36.2535C1175.07 36.9031 1175.01 37.6904 1175.22 38.453L1177.32 46.1291L1177.34 46.1624ZM1206.59 54.2756L1209.14 63.6102C1209.05 63.8601 1209.03 64.1517 1209.11 64.4226L1211.92 74.7282C1212 75.0115 1212.16 75.2575 1212.37 75.4411L1215.28 86.0925C1215.56 87.1093 1215.06 88.1295 1214.16 88.341L1186.25 95.1352C1185.36 95.3509 1184.39 94.7041 1184.12 93.6748L1175.42 61.8538C1175.14 60.837 1175.64 59.821 1176.54 59.6053L1178.47 59.1325L1201.57 53.4954C1201.57 53.4954 1201.58 53.4996 1201.6 53.5038C1201.6 53.5038 1201.61 53.5079 1201.62 53.4996L1204.43 52.8194C1205.32 52.6037 1206.29 53.2505 1206.56 54.2798L1206.59 54.2756ZM1214.84 72.6858L1214.04 72.8807L1211.91 65.1005L1212.71 64.9055L1214.84 72.6858ZM1209.99 95.8729C1209.64 98.2805 1209.81 100.834 1210.48 103.272L1212.58 110.948C1212.63 111.128 1212.54 111.311 1212.38 111.348L1205.74 112.97C1205.74 112.97 1205.62 113.007 1205.58 113.032C1205.53 113.04 1205.46 113.045 1205.4 113.061L1198.76 114.683C1198.6 114.72 1198.43 114.604 1198.38 114.424L1196.28 106.748C1195.61 104.323 1194.45 102.001 1192.9 100.054L1190.38 96.8602L1210.56 91.9408L1209.99 95.8854L1209.99 95.8729ZM1184.3 35.9505C1184.3 35.9505 1184.42 35.9132 1184.46 35.8882C1184.51 35.8799 1184.57 35.8759 1184.64 35.8593L1191.28 34.2374C1191.38 34.2084 1191.46 34.2501 1191.51 34.2793C1191.55 34.296 1191.62 34.3753 1191.65 34.4919L1193.75 42.168C1194.42 44.5933 1195.58 46.915 1197.12 48.8622L1199.15 51.4182L1179.58 56.1799L1180.04 53.0184C1180.39 50.6108 1180.22 48.0568 1179.55 45.619L1177.45 37.943C1177.4 37.7638 1177.49 37.5805 1177.65 37.5432L1184.29 35.9214L1184.3 35.9505Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1073.3 46.1429C1073.29 49.0504 1074.75 51.8363 1077.07 53.4239L1122.71 84.3548C1123.22 84.7003 1123.76 84.9761 1124.32 85.1779C1126.29 85.8945 1128.43 85.6586 1130.09 84.4695L1133.05 82.3536C1133.71 81.8861 1134.05 81.0692 1133.99 80.1698C1133.93 79.2704 1133.46 78.4362 1132.74 77.9509L1129.06 75.4583L1145.29 42.5645C1145.42 42.2813 1145.46 41.9364 1145.36 41.6077C1145.27 41.2709 1145.06 40.9955 1144.8 40.8063L1097.22 8.55925C1096.96 8.38237 1096.64 8.3081 1096.35 8.38993C1096.07 8.47175 1095.83 8.66454 1095.68 8.94364L1079.48 41.8621L1076.72 39.9823C1075.99 39.4929 1075.13 39.4345 1074.43 39.8321C1073.73 40.2297 1073.31 41.0177 1073.32 41.9253L1073.32 46.1634L1073.3 46.1429ZM1142.73 42.2333L1127.05 74.0804L1081.48 43.1989L1097.19 11.3764L1142.73 42.2497L1142.73 42.2333ZM1098.54 57.6192L1107.67 63.8259C1107.02 64.2277 1106.18 64.2144 1105.45 63.725L1099.71 59.8381C1098.99 59.3486 1098.55 58.4857 1098.53 57.6151L1098.54 57.6192ZM1098.66 61.9806L1104.4 65.8676C1104.73 66.0938 1105.08 66.2748 1105.43 66.4025C1107.03 66.9792 1108.71 66.5539 1109.82 65.2943L1131.7 80.1756L1128.74 82.2915C1127.3 83.3248 1125.35 83.294 1123.76 82.2123L1078.13 51.2814C1076.56 50.2202 1075.58 48.3383 1075.59 46.3876L1075.58 42.1495C1075.58 42.1495 1075.59 42.1249 1075.61 42.1043L1075.3 41.5168L1075.65 42.1085L1096.41 56.1837C1095.93 58.3351 1096.83 60.7467 1098.67 61.997L1098.66 61.9806Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M984.854 13.4863C987.894 14.5891 990.598 16.8488 992.438 19.8613C994.69 23.529 995.491 27.9365 994.617 31.9756C994.534 32.3585 994.442 32.725 994.328 33.0832C994.233 33.4084 994.263 33.7791 994.412 34.1128C994.575 34.4384 994.838 34.694 995.146 34.8055L1024.27 45.3712C1024.58 45.4827 1024.92 45.446 1025.18 45.2733C1025.44 45.1006 1025.62 44.8084 1025.67 44.4543C1025.72 44.0713 1025.79 43.6843 1025.87 43.3137C1026.74 39.2869 1029.19 36.0443 1032.6 34.4294C1035.57 33.0159 1039.07 32.9949 1042.24 34.3161C1042.52 34.4194 1042.84 34.428 1043.1 34.2841C1043.38 34.1444 1043.57 33.8934 1043.65 33.5763C1043.73 33.2593 1043.7 32.9133 1043.56 32.5961C1043.4 32.287 1043.16 32.0397 1042.87 31.9199C1042.06 31.5731 1041.21 31.3169 1040.3 31.11L1042.16 -6.7849L1043.73 -6.2149C1044.85 -5.81011 1045.96 -6.45962 1046.22 -7.67013L1046.52 -9.05357C1046.78 -10.2641 1046.09 -11.5662 1044.98 -11.971L1038.42 -14.3501C1037.3 -14.7549 1036.19 -14.1054 1035.93 -12.8949L1035.63 -11.5115C1035.37 -10.3009 1036.06 -8.99883 1037.17 -8.59405L1039.9 -7.60686L1038.01 30.7987C1035.76 30.6727 1033.53 31.1028 1031.54 32.0355C1028.58 33.4367 1026.22 35.9011 1024.79 39.0172C1024.67 38.9223 1024.55 38.8522 1024.42 38.8026L997.238 28.9432C997.248 25.3232 996.204 21.6403 994.288 18.5207C992.118 14.989 988.947 12.3334 985.372 11.0364C984.757 10.8134 984.138 11.1751 983.994 11.8422C983.85 12.5092 984.233 13.2344 984.848 13.4574L984.854 13.4863ZM997.073 31.5211L1023.91 41.2566C1023.91 41.2566 1023.94 41.269 1023.97 41.2773C1023.85 41.6725 1023.74 42.0883 1023.65 42.4959L1023.65 42.5206L996.846 32.7976L996.851 32.7729C996.937 32.3776 997.014 31.9658 997.073 31.5211ZM1037.92 -10.9201L1038.12 -11.8465L1044.26 -9.62019L1044.06 -8.69378L1037.92 -10.9201Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M992.209 33.6497C993.699 26.7656 989.753 19.2977 983.409 16.9957C977.065 14.6937 970.697 18.4187 969.206 25.3029C967.716 32.187 971.662 39.6549 978.006 41.9569C984.35 44.2589 990.718 40.5339 992.209 33.6497ZM978.531 39.5301C973.419 37.6753 970.242 31.6613 971.443 26.1144C972.644 20.5674 977.772 17.5676 982.884 19.4225C987.996 21.2773 991.173 27.2913 989.972 32.8382C988.772 38.3852 983.643 41.385 978.531 39.5301Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M982.192 22.6727C978.735 21.4182 975.255 23.4538 974.443 27.2054C973.631 30.957 975.787 35.0379 979.244 36.2924C982.701 37.5469 986.181 35.5113 986.994 31.7597C987.806 28.0081 985.65 23.9272 982.192 22.6727ZM979.772 33.8532C977.547 33.0459 976.159 30.4189 976.682 28.0045C977.204 25.5901 979.445 24.2797 981.67 25.0871C983.895 25.8944 985.283 28.5214 984.76 30.9358C984.237 33.3502 981.997 34.6606 979.772 33.8532Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1026.07 43.9953C1024.58 50.8794 1028.52 58.3473 1034.87 60.6493C1041.21 62.9513 1047.58 59.2262 1049.07 52.3421C1050.56 45.4579 1046.61 37.9901 1040.27 35.688C1033.93 33.386 1027.56 37.1111 1026.07 43.9953ZM1035.39 58.2225C1030.28 56.3677 1027.1 50.3537 1028.3 44.8067C1029.5 39.2598 1034.63 36.26 1039.74 38.1148C1044.86 39.9697 1048.03 45.9836 1046.83 51.5306C1045.63 57.0775 1040.5 60.0774 1035.39 58.2225Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1039.03 41.3563C1035.57 40.1018 1032.09 42.1373 1031.28 45.889C1030.47 49.6406 1032.61 53.7173 1036.08 54.976C1039.55 56.2346 1043.02 54.1949 1043.83 50.4433C1044.64 46.6917 1042.5 42.6149 1039.03 41.3563ZM1036.61 52.5368C1034.39 51.7295 1033 49.1025 1033.52 46.6881C1034.04 44.2737 1036.28 42.9633 1038.51 43.7707C1040.73 44.578 1042.12 47.205 1041.6 49.6194C1041.08 52.0338 1038.84 53.3442 1036.61 52.5368Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M869.22 -48.7175L861.38 -54.7408L863.026 -57.6034C866.14 -63.0305 864.463 -70.6929 859.272 -74.6821C854.092 -78.6672 847.339 -77.4971 844.222 -72.0576L842.577 -69.1949L832.811 -76.7084C832.304 -77.1069 831.629 -77.0164 831.274 -76.5152L802.596 -34.8518C802.415 -34.5826 802.337 -34.222 802.407 -33.8613C802.477 -33.5006 802.669 -33.1895 802.943 -32.9695L845.969 0.131373C846.075 0.21025 846.185 0.276692 846.299 0.318268C846.494 0.388946 846.688 0.405725 846.884 0.356194C847.194 0.294341 847.451 0.0790495 847.592 -0.231701L869.65 -46.9926C869.919 -47.5519 869.724 -48.3066 869.218 -48.7051L869.22 -48.7175ZM805.207 -34.2397L832.547 -73.9479L841.403 -67.1401L838.74 -62.4877L837.036 -63.8036C836.771 -64.007 836.456 -64.0943 836.16 -64.0408C835.864 -63.9872 835.616 -63.8092 835.457 -63.5316C835.298 -63.2541 835.251 -62.9225 835.324 -62.5742C835.399 -62.2384 835.583 -61.9438 835.848 -61.7404L841.43 -57.4482C841.537 -57.3693 841.646 -57.3029 841.761 -57.2613C841.932 -57.1989 842.126 -57.1822 842.306 -57.211C842.601 -57.2646 842.85 -57.4425 843.009 -57.7201C843.33 -58.2877 843.159 -59.1004 842.618 -59.5113L840.712 -60.9808L843.375 -65.6332L858.226 -54.2094L855.563 -49.557L853.795 -50.9227C853.257 -51.3461 852.537 -51.2183 852.216 -50.6508C851.896 -50.0832 852.066 -49.2705 852.607 -48.8596L858.19 -44.5673C858.296 -44.4885 858.405 -44.422 858.52 -44.3804C858.692 -44.3181 858.886 -44.3013 859.065 -44.3301C859.361 -44.3837 859.621 -44.5575 859.78 -44.8351C859.939 -45.1126 859.986 -45.4442 859.913 -45.7925C859.837 -46.1284 859.654 -46.4229 859.389 -46.6263L857.547 -48.046L860.209 -52.6984L867.137 -47.3683L846.108 -2.79509L805.221 -34.248L805.207 -34.2397ZM858.098 -72.6273C860.079 -71.1038 861.473 -68.868 862.033 -66.318C862.593 -63.768 862.241 -61.2273 861.05 -59.1518L859.405 -56.2891L844.554 -67.7129L846.199 -70.5756C848.659 -74.8592 853.989 -75.7946 858.089 -72.6439L858.098 -72.6273Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M551.852 122.583C551.289 120.532 551.156 118.395 551.448 116.358L552.198 111.172L554.036 110.72C555.06 110.471 555.894 109.776 556.397 108.773C556.9 107.77 556.997 106.578 556.678 105.411L553.895 95.2516L554.787 95.0359C555.953 94.758 556.613 93.4339 556.24 92.1129L554.047 84.1076C553.689 82.7783 552.445 81.9229 551.276 82.2133L550.384 82.429L547.96 73.5986C547.641 72.4317 546.94 71.4228 545.985 70.7802C545.033 70.1252 543.95 69.9074 542.926 70.1563L540.788 70.6747L537.967 67.1181C536.67 65.4753 535.687 63.5287 535.133 61.4951L533.031 53.8191C532.823 53.0565 532.367 52.4061 531.751 51.9805C531.135 51.5549 530.419 51.4167 529.75 51.5784L523.11 53.2003C523.11 53.2003 522.99 53.2376 522.948 53.2626C522.896 53.2709 522.833 53.275 522.767 53.2916L516.127 54.9134C515.458 55.0752 514.914 55.5245 514.587 56.1741C514.259 56.8236 514.201 57.6109 514.408 58.3735L516.511 66.0496C517.074 68.0999 517.207 70.2372 516.915 72.2741L516.272 76.6769L515.026 76.9797C512.913 77.494 511.725 79.8799 512.384 82.2885L521.088 114.11C521.407 115.276 522.108 116.285 523.062 116.928C523.366 117.132 523.69 117.304 524.012 117.421C524.704 117.671 525.427 117.718 526.121 117.552L527.067 117.315L530.384 121.51C531.681 123.153 532.664 125.099 533.218 127.133L535.321 134.809C535.603 135.855 536.351 136.652 537.226 136.969C537.664 137.128 538.141 137.166 538.601 137.05L545.241 135.428C545.241 135.428 545.361 135.39 545.415 135.37C545.467 135.361 545.53 135.357 545.595 135.341L552.235 133.719C553.613 133.383 554.385 131.83 553.954 130.259L551.852 122.583ZM519.205 72.8889C519.553 70.4813 519.385 67.9274 518.72 65.4895L516.618 57.8135C516.569 57.6343 516.659 57.4511 516.816 57.4138L523.456 55.7919C523.456 55.7919 523.576 55.7545 523.619 55.7296C523.67 55.7213 523.733 55.7172 523.796 55.7131L530.436 54.0913C530.542 54.0622 530.62 54.104 530.663 54.1332C530.71 54.1499 530.779 54.2291 530.804 54.3458L532.907 62.0218C533.574 64.4472 534.737 66.7689 536.279 68.7161L538.31 71.272L518.735 76.0338L519.197 72.8723L519.205 72.8889ZM524.144 114.746C523.745 114.467 523.45 114.05 523.309 113.554L514.605 81.7327C514.464 81.2368 514.512 80.7286 514.727 80.308C514.943 79.8875 515.294 79.5837 515.726 79.4842L543.633 72.69C543.921 72.6194 544.228 72.6364 544.528 72.7451C544.666 72.7952 544.799 72.8703 544.929 72.958C545.329 73.2375 545.624 73.6544 545.765 74.1503L548.316 83.4849C548.225 83.7348 548.211 84.0264 548.289 84.2973L551.114 94.607C551.189 94.8904 551.347 95.1364 551.559 95.3074L554.483 105.963C554.612 106.455 554.576 106.967 554.36 107.388C554.145 107.808 553.796 108.099 553.362 108.212L525.455 115.006C525.021 115.118 524.558 115.017 524.158 114.738L524.144 114.746ZM554.009 92.5438L553.209 92.7387L551.079 84.9585L551.879 84.7635L554.009 92.5438ZM544.912 132.815C544.912 132.815 544.792 132.853 544.749 132.878C544.698 132.886 544.635 132.89 544.569 132.907L537.929 134.529C537.772 134.566 537.598 134.449 537.55 134.27L535.447 126.594C534.78 124.168 533.617 121.847 532.075 119.9L529.548 116.706L549.729 111.786L549.16 115.731C548.813 118.138 548.98 120.692 549.645 123.13L551.748 130.806C551.784 130.927 551.753 131.01 551.731 131.056C551.72 131.106 551.655 131.177 551.552 131.194L544.912 132.815Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M998.585 229.81L951.009 197.563C950.741 197.386 950.427 197.312 950.139 197.394C949.855 197.463 949.614 197.668 949.468 197.948L933.268 230.866L930.502 228.986C929.775 228.497 928.917 228.438 928.219 228.836C927.52 229.233 927.092 230.021 927.103 230.929L927.104 235.167C927.099 238.075 928.554 240.86 930.881 242.448L976.512 273.379C977.025 273.724 977.566 274 978.123 274.202C980.1 274.919 982.234 274.683 983.9 273.494L986.859 271.378C987.511 270.91 987.86 270.093 987.797 269.194C987.735 268.294 987.266 267.46 986.55 266.975L982.866 264.47L999.097 231.576C999.232 231.293 999.27 230.948 999.17 230.62C999.081 230.295 998.873 230.008 998.608 229.818L998.585 229.81ZM977.55 271.245L931.919 240.314C930.348 239.253 929.371 237.371 929.38 235.408L929.449 231.129L950.208 245.204C949.729 247.355 950.628 249.767 952.465 251.017L958.202 254.904C958.533 255.13 958.875 255.307 959.227 255.435C960.817 256.011 962.525 255.594 963.625 254.306L985.484 269.126L985.491 269.208L982.533 271.324C981.096 272.357 979.142 272.326 977.55 271.245ZM959.255 252.761L953.517 248.875C952.79 248.385 952.352 247.522 952.332 246.652L961.478 252.85C960.824 253.264 959.968 253.259 959.243 252.757L959.255 252.761ZM935.276 232.231L950.981 200.409L996.526 231.282L980.853 263.129L935.287 232.235L935.276 232.231Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M299.024 49.5767C299.324 49.9527 299.697 50.2214 300.107 50.3704C300.256 50.4242 300.407 50.4657 300.563 50.4824C301.772 50.6405 302.779 49.6839 302.798 48.3423C302.816 47.6942 302.597 47.0541 302.19 46.546C301.784 46.0378 301.24 45.7069 300.663 45.6444C300.077 45.5653 299.52 45.7505 299.099 46.1587C298.679 46.567 298.431 47.1446 298.427 47.7845C298.41 48.4326 298.629 49.0726 299.035 49.5808L299.024 49.5767Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M326.374 -9.64033C326.435 -12.4947 324.392 -15.0771 321.813 -15.4081L284.331 -20.2304C283.088 -20.3854 281.904 -20.0086 280.998 -19.1412C280.092 -18.2738 279.579 -17.0486 279.551 -15.6609L278.236 45.7977C278.182 48.2782 279.729 50.5734 281.842 51.3401C282.152 51.4526 282.47 51.5278 282.794 51.578L320.276 56.4002C321.519 56.5553 322.703 56.1784 323.609 55.311C324.515 54.4436 325.028 53.2184 325.056 51.8307L326.371 -9.62787L326.374 -9.64033ZM280.549 46.0994L280.673 40.2036L322.868 45.6334L322.743 51.5291C322.729 52.223 322.457 52.8501 322.017 53.2817C321.562 53.7216 320.965 53.908 320.338 53.8284L282.855 49.0061C281.553 48.8427 280.524 47.5286 280.552 46.0869L280.549 46.0994ZM324.061 -9.94196L323.977 -5.8328L281.782 -11.2625L281.867 -15.3717C281.894 -16.8134 282.984 -17.8427 284.286 -17.6793L321.769 -12.857C322.396 -12.7774 322.986 -12.4153 323.416 -11.883C323.854 -11.3341 324.089 -10.6441 324.064 -9.95441L324.061 -9.94196ZM323.918 -3.27341L322.929 43.0615L280.735 37.6318L281.723 -8.70316L323.918 -3.27341Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1263.57 311.616C1263.6 309.865 1263.01 308.126 1261.92 306.734C1260.81 305.339 1259.34 304.472 1257.74 304.265L1248.64 303.103L1244.87 298.353C1243.92 297.147 1242.63 296.387 1241.25 296.217L1233.68 295.253C1233.61 295.241 1233.54 295.241 1233.46 295.253C1233.39 295.228 1233.33 295.204 1233.25 295.204L1225.69 294.24C1224.33 294.066 1222.99 294.508 1222 295.45L1218.06 299.223L1208.96 298.061C1205.67 297.639 1202.94 300.257 1202.86 303.891L1202.16 338.369C1202.12 340.121 1202.71 341.86 1203.8 343.252C1204.61 344.274 1205.63 345.013 1206.74 345.416C1207.14 345.56 1207.55 345.659 1207.98 345.721L1256.79 351.933C1258.37 352.136 1259.89 351.637 1261.04 350.543C1262.2 349.437 1262.85 347.867 1262.89 346.103L1263.59 311.625L1263.57 311.616ZM1243.22 299.943L1245.41 302.701L1221.28 299.633L1223.56 297.437C1224.12 296.908 1224.87 296.663 1225.63 296.766L1233.2 297.73C1233.27 297.742 1233.34 297.742 1233.42 297.73C1233.48 297.755 1233.55 297.78 1233.63 297.78L1241.19 298.743C1241.96 298.838 1242.68 299.27 1243.22 299.943ZM1204.43 338.663L1205.14 304.184C1205.16 303.106 1205.56 302.122 1206.27 301.45C1206.98 300.766 1207.91 300.467 1208.89 300.583L1257.7 306.795C1257.96 306.824 1258.21 306.89 1258.45 306.977C1260.11 307.577 1261.32 309.371 1261.29 311.323L1260.59 345.802C1260.54 348.041 1258.86 349.659 1256.82 349.398L1208.01 343.199C1205.98 342.938 1204.37 340.91 1204.42 338.659L1204.43 338.663Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1225.71 331.858C1227.04 333.544 1228.72 334.78 1230.56 335.447C1231.22 335.687 1231.91 335.857 1232.6 335.948C1235.23 336.285 1237.72 335.467 1239.62 333.648C1241.53 331.83 1242.6 329.226 1242.66 326.324C1242.78 320.318 1238.48 314.873 1233.05 314.182C1227.62 313.495 1223.12 317.816 1222.98 323.818C1222.92 326.72 1223.89 329.582 1225.71 331.883L1225.71 331.858ZM1240.35 326.008C1240.26 330.606 1236.81 333.922 1232.64 333.385C1228.5 332.869 1225.18 328.687 1225.28 324.076C1225.33 321.851 1226.16 319.854 1227.61 318.461C1229.07 317.067 1230.98 316.437 1232.99 316.687C1233.53 316.762 1234.05 316.882 1234.55 317.064C1237.94 318.294 1240.44 321.979 1240.36 325.983L1240.35 326.008Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M400.642 19.3097C400.053 16.7295 398.357 14.587 396.114 13.5854L384.033 8.18335C381.778 7.17753 379.388 7.48856 377.606 9.02107L370.164 15.4016C368.463 16.8548 367.218 18.8519 366.541 21.1633L353.909 64.7653C353.664 65.6096 353.739 66.5295 354.119 67.3703C354.498 68.211 355.144 68.8639 355.917 69.2118L386.457 82.8532C386.527 82.8783 386.596 82.9035 386.666 82.9287C388.217 83.4906 389.809 82.6602 390.292 81.0093L402.924 37.4072C403.588 35.0917 403.648 32.5707 403.086 30.095L400.622 19.2888L400.642 19.3097ZM388.081 80.0328C388.026 80.2292 387.892 80.3838 387.723 80.4714C387.554 80.559 387.344 80.5504 387.161 80.4708L356.633 66.8336C356.245 66.666 356.025 66.1807 356.153 65.7669L368.785 22.1649C369.325 20.305 370.336 18.6964 371.704 17.5146L379.146 11.1341C380.235 10.2029 381.661 9.96191 383.04 10.4609C383.144 10.4986 383.248 10.5364 383.352 10.5741L395.433 15.9762C396.902 16.63 398.009 18.0318 398.391 19.7255L400.856 30.5316C401.311 32.5222 401.268 34.5624 400.724 36.4349L388.092 80.037L388.081 80.0328Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M387.923 19.4472C386.781 18.9258 385.545 19.5189 385.189 20.7652C385.009 21.3677 385.063 22.0283 385.338 22.6354C385.613 23.2425 386.067 23.7012 386.627 23.9578C386.684 23.9785 386.729 23.995 386.786 24.0157C387.3 24.202 387.833 24.182 388.302 23.9513C388.824 23.7001 389.195 23.234 389.375 22.6315C389.555 22.029 389.501 21.3684 389.226 20.7613C388.951 20.1542 388.497 19.6955 387.937 19.4389L387.923 19.4472Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1179.34 285.036L1119.69 257.067C1118.48 256.495 1117.19 256.477 1116.04 256.985C1114.89 257.505 1114.04 258.502 1113.65 259.797L1103.31 293.138C1102.91 294.429 1103.01 295.875 1103.58 297.199C1104.15 298.528 1105.13 299.568 1106.34 300.135L1129.96 311.219L1129.12 313.947L1123.62 311.363C1123.33 311.22 1123.02 311.228 1122.76 311.342C1122.48 311.468 1122.29 311.7 1122.18 312.005C1122.09 312.314 1122.1 312.661 1122.24 312.974C1122.38 313.288 1122.61 313.529 1122.91 313.676L1146.31 324.654C1146.31 324.654 1146.37 324.678 1146.41 324.69C1146.97 324.895 1147.56 324.606 1147.75 324.003C1147.95 323.364 1147.63 322.614 1147.03 322.345L1141.46 319.74L1142.37 317.036L1165.99 328.12C1167.2 328.688 1168.49 328.71 1169.64 328.202C1170.79 327.681 1171.64 326.684 1172.03 325.39L1182.37 292.049C1183.2 289.37 1181.84 286.232 1179.34 285.064L1179.34 285.036ZM1139.96 316.785L1139.55 318.125L1131.46 314.332L1131.88 312.993L1139.96 316.785ZM1166.71 325.783L1107.06 297.814C1105.75 297.194 1105.03 295.551 1105.47 294.142L1115.81 260.802C1116.22 259.474 1117.52 258.824 1118.76 259.273C1118.84 259.302 1118.91 259.326 1118.99 259.355L1178.63 287.324C1179.95 287.945 1180.66 289.587 1180.22 290.996L1169.88 324.336C1169.68 325.012 1169.23 325.537 1168.63 325.806C1168.03 326.078 1167.34 326.053 1166.71 325.759L1166.71 325.783Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1078.49 246.753C1078.1 246.612 1077.7 246.562 1077.3 246.549L1076.03 244.154C1075.71 243.543 1074.97 243.273 1074.45 243.578L1073.18 244.32C1072.65 244.633 1072.48 245.401 1072.81 246.041L1074.08 248.453C1073.9 248.8 1073.74 249.171 1073.66 249.567C1073.15 251.907 1074.49 254.452 1076.65 255.234C1077.02 255.367 1077.4 255.425 1077.78 255.429L1079.24 258.205C1079.4 258.502 1079.66 258.742 1079.95 258.85C1080.25 258.957 1080.56 258.937 1080.82 258.776L1082.09 258.035C1082.34 257.874 1082.53 257.622 1082.6 257.3C1082.67 256.978 1082.63 256.628 1082.46 256.326L1081.01 253.583C1081.21 253.216 1081.38 252.837 1081.47 252.416C1081.98 250.076 1080.63 247.531 1078.48 246.749L1078.49 246.753ZM1077.96 249.18C1078.89 249.515 1079.46 250.605 1079.24 251.608C1079.03 252.611 1078.1 253.155 1077.17 252.82C1076.25 252.484 1075.67 251.394 1075.89 250.391C1076.11 249.388 1077.04 248.844 1077.96 249.18Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1043.88 251.653L1043.89 251.748L1043.92 251.719C1043.92 251.719 1043.92 251.732 1043.94 251.752C1044.16 252.074 1044.36 252.4 1044.56 252.727L1045.52 252.088L1045.97 251.796L1046.46 251.479C1046.46 251.479 1046.45 251.462 1046.44 251.446L1046.38 251.33C1046.17 250.987 1046.1 250.575 1046.17 250.228L1046.51 248.669C1046.66 247.976 1047.31 247.597 1047.95 247.829L1049.58 248.421C1049.9 248.537 1050.18 248.813 1050.35 249.168L1050.42 249.288L1051.44 248.749L1052.41 248.234C1052.25 247.896 1052.1 247.561 1051.96 247.202L1051.98 247.186L1051.92 247.136C1051.7 246.616 1051.23 246.298 1050.75 246.322C1050.52 246.174 1050.3 246.054 1050.08 245.975L1048.45 245.383C1046.58 244.705 1044.69 245.808 1044.26 247.838L1043.92 249.397C1043.87 249.632 1043.85 249.892 1043.85 250.184C1043.58 250.597 1043.57 251.154 1043.86 251.616L1043.88 251.653Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1072.34 274.902C1071.15 274.471 1069.92 274.185 1068.72 274.056C1068.08 273.985 1067.58 274.508 1067.57 275.214C1067.57 275.549 1067.69 275.9 1067.92 276.168C1068.13 276.433 1068.42 276.59 1068.72 276.619C1069.75 276.728 1070.8 276.972 1071.82 277.345C1079.16 280.007 1083.72 288.648 1082 296.61C1080.28 304.571 1072.91 308.881 1065.57 306.219C1058.23 303.557 1053.67 294.916 1055.39 286.954C1055.64 285.791 1056.02 284.685 1056.51 283.661C1056.8 283.071 1056.57 282.266 1056.01 281.902C1055.74 281.724 1055.42 281.662 1055.13 281.732C1054.84 281.814 1054.61 282.008 1054.47 282.305C1053.89 283.498 1053.45 284.793 1053.16 286.143C1051.14 295.442 1056.48 305.537 1065.05 308.646C1073.61 311.755 1082.22 306.72 1084.24 297.421C1086.25 288.123 1080.92 278.028 1072.35 274.918L1072.34 274.902Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1081.98 234.564C1073.41 231.454 1064.8 236.49 1062.79 245.788C1062.51 247.076 1062.37 248.413 1062.36 249.759C1062.36 250.106 1062.48 250.444 1062.71 250.713C1062.92 250.977 1063.22 251.139 1063.51 251.164C1063.82 251.197 1064.1 251.098 1064.32 250.872C1064.54 250.657 1064.66 250.339 1064.66 250.005C1064.66 248.857 1064.78 247.714 1065.02 246.6C1066.75 238.638 1074.12 234.328 1081.45 236.99C1088.79 239.653 1093.36 248.294 1091.63 256.255C1089.91 264.216 1082.54 268.526 1075.2 265.864C1074.13 265.475 1073.1 264.954 1072.13 264.309C1071.86 264.131 1071.54 264.069 1071.26 264.139C1070.96 264.217 1070.73 264.415 1070.59 264.699C1070.46 264.984 1070.43 265.335 1070.52 265.661C1070.62 265.991 1070.82 266.276 1071.1 266.458C1072.23 267.215 1073.44 267.827 1074.68 268.279C1083.25 271.388 1091.86 266.353 1093.87 257.054C1095.88 247.755 1090.55 237.661 1081.98 234.551L1081.98 234.564Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1074.66 289.808C1074.73 289.486 1074.68 289.136 1074.51 288.834L1073.72 287.347C1073.56 287.033 1073.31 286.81 1073.01 286.702C1072.72 286.595 1072.41 286.615 1072.15 286.776L1069.81 288.144C1069.46 287.883 1069.1 287.66 1068.72 287.519C1066.56 286.737 1064.39 288.006 1063.88 290.346C1063.79 290.767 1063.78 291.205 1063.81 291.655L1061.77 292.849C1061.51 292.998 1061.32 293.274 1061.25 293.584C1061.18 293.893 1061.23 294.257 1061.4 294.558L1062.18 296.045C1062.35 296.359 1062.59 296.582 1062.89 296.69C1063.19 296.797 1063.5 296.777 1063.76 296.616L1065.8 295.409C1066.14 295.653 1066.49 295.872 1066.85 296.005C1069.01 296.787 1071.18 295.518 1071.69 293.178C1071.77 292.782 1071.79 292.361 1071.76 291.935L1074.13 290.551C1074.38 290.403 1074.57 290.126 1074.64 289.817L1074.66 289.808ZM1067.39 293.57C1066.47 293.234 1065.89 292.144 1066.11 291.141C1066.33 290.138 1067.26 289.594 1068.18 289.929C1069.11 290.265 1069.68 291.355 1069.46 292.358C1069.25 293.361 1068.32 293.905 1067.39 293.57Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1039.68 268.853L1039.68 268.878C1039.23 269.051 1038.99 269.538 1039.04 270.104C1038.93 270.356 1038.84 270.604 1038.78 270.852L1038.4 272.636C1037.96 274.669 1039.13 276.884 1041 277.564L1042.44 278.086C1042.65 278.165 1042.89 278.21 1043.14 278.235C1043.27 278.347 1043.4 278.434 1043.53 278.484C1043.59 278.504 1043.66 278.529 1043.72 278.538C1043.99 278.583 1044.24 278.513 1044.46 278.353L1044.52 278.373L1044.5 278.328C1044.51 278.315 1044.53 278.311 1044.55 278.303C1044.8 278.076 1045.08 277.87 1045.37 277.68L1044.7 276.543L1044.07 275.456L1043.95 275.522C1043.65 275.72 1043.29 275.777 1042.96 275.657L1041.52 275.135C1040.88 274.903 1040.48 274.142 1040.63 273.449L1041.02 271.664C1041.1 271.305 1041.32 271.012 1041.64 270.859L1041.76 270.785L1041.21 269.648L1040.63 268.449C1040.33 268.606 1040.02 268.75 1039.7 268.862L1039.68 268.853Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1065.13 252.185L1065.77 253.341L1066.4 254.434L1066.51 254.369C1066.8 254.179 1067.15 254.134 1067.47 254.25L1069.1 254.842C1069.74 255.073 1070.14 255.833 1069.99 256.526L1069.65 258.085C1069.58 258.443 1069.35 258.736 1069.05 258.892C1069.01 258.917 1068.97 258.93 1068.91 258.962L1069.46 260.11L1070.04 261.307C1070.34 261.15 1070.65 261.006 1070.97 260.883L1070.97 260.87C1071.43 260.689 1071.67 260.191 1071.61 259.621C1071.72 259.37 1071.81 259.135 1071.86 258.9L1072.2 257.341C1072.64 255.312 1071.47 253.099 1069.6 252.421L1067.97 251.829C1067.75 251.75 1067.53 251.709 1067.27 251.68C1066.88 251.353 1066.39 251.308 1066 251.555L1065.87 251.546L1065.91 251.6C1065.65 251.814 1065.37 252.008 1065.09 252.185L1065.13 252.185Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1032.6 284.74C1032.98 284.876 1033.37 284.939 1033.76 284.947L1035.01 287.364C1035.18 287.678 1035.43 287.901 1035.72 288.008C1036.02 288.116 1036.33 288.096 1036.59 287.935L1037.86 287.193C1038.11 287.045 1038.3 286.781 1038.37 286.459C1038.44 286.137 1038.39 285.786 1038.23 285.485L1036.96 283.089C1037.16 282.722 1037.33 282.342 1037.42 281.921C1037.93 279.581 1036.58 277.037 1034.43 276.255C1034.04 276.114 1033.64 276.064 1033.24 276.051L1031.79 273.309C1031.46 272.681 1030.75 272.424 1030.21 272.733L1028.94 273.475C1028.67 273.631 1028.49 273.887 1028.42 274.209C1028.35 274.531 1028.4 274.882 1028.57 275.183L1030.03 277.959C1029.85 278.306 1029.68 278.673 1029.6 279.069C1029.09 281.409 1030.44 283.953 1032.59 284.736L1032.6 284.74ZM1033.13 282.313C1032.2 281.978 1031.63 280.887 1031.85 279.885C1032.06 278.882 1032.99 278.338 1033.92 278.673C1034.84 279.009 1035.42 280.099 1035.2 281.102C1034.98 282.105 1034.05 282.649 1033.13 282.313Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1058.8 282.79C1058.94 283.175 1059.24 283.468 1059.59 283.597C1059.73 283.647 1059.87 283.659 1060.02 283.647C1060.25 283.796 1060.47 283.916 1060.69 283.995L1062.13 284.517C1064 285.197 1065.89 284.091 1066.33 282.059L1066.71 280.274C1066.77 280.039 1066.78 279.778 1066.79 279.485C1067.05 279.084 1067.06 278.527 1066.78 278.051L1066.78 277.944L1066.74 277.973C1066.74 277.973 1066.75 277.96 1066.74 277.944C1066.51 277.621 1066.31 277.307 1066.11 276.968L1065.18 277.566L1064.22 278.205C1064.22 278.205 1064.23 278.222 1064.24 278.239L1064.3 278.354C1064.51 278.697 1064.58 279.098 1064.5 279.458L1064.12 281.242C1063.97 281.936 1063.32 282.316 1062.68 282.084L1061.24 281.562C1060.91 281.441 1060.61 281.16 1060.45 280.78L1060.38 280.635L1059.35 281.159L1058.88 281.402L1058.37 281.658C1058.54 282.013 1058.7 282.377 1058.82 282.757C1058.82 282.757 1058.82 282.757 1058.83 282.786L1058.8 282.79Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1049.16 280.747C1048.94 280.495 1048.64 280.333 1048.34 280.304C1048.04 280.275 1047.75 280.382 1047.53 280.596C1047.31 280.811 1047.19 281.129 1047.19 281.463C1047.2 282.668 1047.08 283.866 1046.83 285.029C1045.1 292.991 1037.73 297.301 1030.4 294.639C1023.06 291.976 1018.5 283.336 1020.22 275.374C1021.94 267.413 1029.31 263.103 1036.65 265.765C1037.66 266.133 1038.66 266.63 1039.59 267.233C1040.16 267.602 1040.85 267.408 1041.14 266.806C1041.41 266.199 1041.18 265.419 1040.62 265.055C1039.53 264.352 1038.37 263.773 1037.18 263.342C1028.62 260.233 1020.01 265.268 1017.99 274.567C1015.98 283.865 1021.31 293.96 1029.88 297.07C1038.45 300.179 1047.06 295.144 1049.07 285.845C1049.37 284.495 1049.51 283.092 1049.5 281.684C1049.5 281.338 1049.37 281.011 1049.15 280.743L1049.16 280.747Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1036.53 242.681L1037.31 244.168C1037.47 244.478 1037.73 244.705 1038.02 244.813C1038.32 244.92 1038.63 244.888 1038.89 244.739L1041.25 243.355C1041.58 243.595 1041.93 243.814 1042.29 243.946C1044.45 244.729 1046.62 243.46 1047.13 241.12C1047.22 240.711 1047.24 240.278 1047.21 239.852L1049.27 238.678C1049.8 238.365 1049.97 237.597 1049.64 236.957L1048.86 235.47C1048.53 234.859 1047.8 234.594 1047.28 234.899L1045.24 236.094C1044.89 235.833 1044.53 235.61 1044.14 235.469C1041.99 234.687 1039.82 235.956 1039.31 238.296C1039.22 238.717 1039.21 239.154 1039.24 239.604L1036.9 240.972C1036.36 241.286 1036.19 242.053 1036.52 242.693L1036.53 242.681ZM1043.62 237.896C1044.54 238.231 1045.12 239.322 1044.9 240.325C1044.68 241.328 1043.75 241.871 1042.83 241.536C1041.9 241.201 1041.33 240.11 1041.55 239.107C1041.76 238.105 1042.69 237.561 1043.62 237.896Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1046.82 223.005C1038.26 219.896 1029.65 224.932 1027.63 234.23C1025.62 243.529 1030.95 253.624 1039.52 256.734C1040.77 257.185 1042.05 257.475 1043.31 257.588C1043.94 257.642 1044.46 257.123 1044.45 256.425C1044.45 256.078 1044.33 255.752 1044.1 255.483C1043.89 255.219 1043.59 255.058 1043.29 255.041C1042.2 254.941 1041.11 254.692 1040.04 254.303C1032.7 251.64 1028.13 242.999 1029.86 235.038C1031.58 227.076 1038.95 222.766 1046.29 225.428C1053.62 228.09 1058.19 236.732 1056.47 244.693C1056.23 245.795 1055.87 246.868 1055.41 247.85C1055.28 248.135 1055.26 248.49 1055.35 248.816C1055.45 249.146 1055.66 249.436 1055.92 249.597C1056.19 249.775 1056.5 249.833 1056.8 249.755C1057.1 249.677 1057.33 249.466 1057.46 249.182C1058 248.026 1058.41 246.788 1058.69 245.5C1060.7 236.202 1055.37 226.107 1046.8 222.997L1046.82 223.005Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M483.659 58.983L475.127 54.3953L476.298 51.2181C477.375 48.3026 477.312 44.987 476.141 41.8738C474.969 38.7606 472.813 36.2446 470.085 34.7709C464.448 31.7444 458.051 34.1681 455.828 40.2027L454.657 43.3799L444.029 37.6557C443.474 37.3601 442.833 37.5713 442.563 38.1319L420.896 85.2826C420.755 85.594 420.748 85.9679 420.861 86.3046C420.971 86.6537 421.218 86.9448 421.517 87.1072L468.357 112.327C468.357 112.327 468.46 112.364 468.517 112.385C468.77 112.477 469.044 112.469 469.289 112.369C469.576 112.245 469.793 111.988 469.891 111.647L484.346 60.6166C484.518 59.9935 484.226 59.2827 483.659 58.983ZM423.528 85.4308L444.185 40.4811L453.826 45.6725L451.929 50.8307L450.076 49.8357C449.788 49.6775 449.47 49.6564 449.189 49.7558C448.904 49.8677 448.681 50.096 448.58 50.395C448.345 51.0222 448.635 51.7994 449.233 52.1241L455.314 55.3921C455.314 55.3921 455.415 55.4421 455.472 55.4629C456.023 55.6629 456.6 55.4018 456.813 54.8204C456.929 54.513 456.919 54.1599 456.803 53.8357C456.676 53.5073 456.45 53.237 456.171 53.0954L454.096 51.9797L455.993 46.8215L472.158 55.5223L470.26 60.6805L468.329 59.6439C467.742 59.3234 467.068 59.5761 466.831 60.2157C466.714 60.523 466.725 60.8762 466.84 61.2004C466.967 61.5287 467.194 61.799 467.473 61.9406L473.554 65.2086C473.554 65.2086 473.666 65.2627 473.712 65.2794C473.953 65.3669 474.201 65.363 474.432 65.2719C474.716 65.16 474.939 64.9317 475.041 64.6327C475.276 64.0055 474.986 63.2283 474.387 62.9036L472.39 61.8295L474.287 56.6712L481.821 60.7219L468.044 109.364L423.533 85.4059L423.528 85.4308ZM462.597 36.5163C464.73 35.7042 467.079 35.8978 469.243 37.0593C471.395 38.2167 473.093 40.2169 474.025 42.6651C474.954 45.1257 474.996 47.735 474.148 50.0483L472.977 53.2255L456.812 44.5247L457.983 41.3476C458.828 39.0467 460.475 37.3325 462.597 36.5163Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M793.607 186.473C789.751 185.073 785.864 187.336 784.956 191.533C784.047 195.73 786.448 200.274 790.316 201.677C794.184 203.081 798.058 200.815 798.967 196.617C799.876 192.42 797.475 187.876 793.607 186.473ZM790.954 198.731C788.592 197.874 787.117 195.081 787.671 192.518C788.226 189.955 790.607 188.563 792.969 189.42C795.331 190.277 796.806 193.069 796.252 195.632C795.697 198.195 793.315 199.588 790.954 198.731Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M809.921 159.546L756.815 190.608C756.494 190.785 756.276 191.106 756.191 191.503C756.105 191.899 756.161 192.32 756.365 192.688C756.557 193.051 756.864 193.336 757.229 193.469C757.595 193.601 757.969 193.577 758.282 193.383L811.387 162.322C812.036 161.943 812.239 161.002 811.838 160.242C811.445 159.498 810.555 159.176 809.921 159.546Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M768.626 157.478C767.72 161.663 770.118 166.219 773.986 167.623C777.854 169.026 781.728 166.76 782.637 162.563C783.546 158.365 781.145 153.822 777.277 152.418C773.409 151.015 769.534 153.281 768.626 157.478ZM771.341 158.464C771.896 155.901 774.277 154.508 776.639 155.365C779.001 156.222 780.476 159.014 779.922 161.577C779.367 164.14 776.985 165.533 774.624 164.676C772.262 163.819 770.786 161.027 771.341 158.464Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1094.68 132.684C1094.05 131.178 1092.95 129.968 1091.59 129.301L1036.32 102.259C1033.49 100.874 1030.4 102.216 1029.41 105.25L1015.59 147.718C1014.61 150.74 1016.1 154.327 1018.93 155.712L1037.5 164.804L1035.41 171.218L1033.49 170.282C1032.91 169.989 1032.25 170.268 1032.03 170.91C1031.82 171.551 1032.14 172.304 1032.74 172.601L1054.67 183.337C1054.67 183.337 1054.75 183.366 1054.79 183.378C1055.34 183.581 1055.93 183.301 1056.13 182.693C1056.34 182.052 1056.01 181.295 1055.42 181.002L1053.5 180.066L1055.59 173.653L1074.17 182.745C1074.36 182.84 1074.54 182.918 1074.72 182.984C1075.93 183.421 1077.18 183.398 1078.31 182.902C1079.61 182.336 1080.6 181.218 1081.07 179.754L1094.9 137.287C1095.37 135.823 1095.29 134.182 1094.66 132.676L1094.68 132.684ZM1051.53 178.539L1037.74 171.796L1039.68 165.859L1053.47 172.602L1051.53 178.539ZM1074.95 180.435L1019.69 153.393C1018.9 153.002 1018.26 152.319 1017.9 151.442C1017.54 150.566 1017.49 149.616 1017.77 148.773L1019.93 142.134L1081.11 172.064L1078.95 178.703C1078.67 179.546 1078.11 180.195 1077.35 180.52C1076.59 180.844 1075.74 180.814 1074.96 180.422L1074.95 180.435ZM1035.57 104.594L1090.83 131.636C1091.62 132.027 1092.26 132.711 1092.62 133.587C1092.98 134.463 1093.03 135.413 1092.75 136.256L1081.85 169.754L1020.67 139.823L1031.57 106.326C1031.85 105.483 1032.41 104.834 1033.17 104.51C1033.93 104.186 1034.78 104.215 1035.56 104.607L1035.57 104.594Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M625.647 27.5409C625.084 25.4906 624.951 23.3533 625.243 21.3164L625.993 16.1305L627.831 15.6784C629.944 15.164 631.132 12.7782 630.473 10.3695L627.69 0.209737L628.582 -0.0059522C629.145 -0.138667 629.613 -0.521439 629.884 -1.08356C630.152 -1.63319 630.21 -2.2997 630.038 -2.94145L627.845 -10.9467C627.475 -12.2803 626.231 -13.1356 625.074 -12.8411L624.182 -12.6254L621.758 -21.4558C621.099 -23.8645 618.837 -25.4125 616.724 -24.8981L614.586 -24.3797L611.767 -27.9488C610.47 -29.5916 609.488 -31.5382 608.934 -33.5718L606.831 -41.2478C606.401 -42.8189 604.929 -43.8245 603.551 -43.4885L596.911 -41.8667C596.911 -41.8667 596.791 -41.8293 596.737 -41.8085C596.685 -41.8002 596.622 -41.7961 596.559 -41.792L589.919 -40.1702C588.541 -39.8342 587.77 -38.2811 588.2 -36.71L590.303 -29.034C590.865 -26.9837 590.999 -24.8463 590.707 -22.8095L590.064 -18.4067L588.817 -18.1039C586.705 -17.5895 585.517 -15.2037 586.176 -12.795L594.88 19.0261C595.316 20.6263 596.467 21.8524 597.804 22.3371C598.484 22.5836 599.204 22.6427 599.913 22.4684L600.859 22.232L604.176 26.4266C605.473 28.0694 606.456 30.0159 607.009 32.0495L609.112 39.7256C609.395 40.7716 610.142 41.5681 611.018 41.8857C611.456 42.0444 611.932 42.0824 612.393 41.9663L619.033 40.3444C619.033 40.3444 619.153 40.307 619.195 40.2821C619.247 40.2738 619.31 40.2697 619.376 40.2531L626.016 38.6313C627.393 38.2953 628.165 36.7422 627.735 35.1711L625.632 27.4951L625.647 27.5409ZM593 -22.153C593.348 -24.5606 593.18 -27.1145 592.515 -29.5524L590.413 -37.2284C590.364 -37.4076 590.454 -37.5908 590.611 -37.6282L597.251 -39.25C597.251 -39.25 597.371 -39.2874 597.414 -39.3123C597.465 -39.3206 597.528 -39.3247 597.594 -39.3413L604.234 -40.9632C604.391 -41.0005 604.565 -40.8837 604.613 -40.7045L606.716 -33.0284C607.384 -30.603 608.546 -28.2813 610.088 -26.3341L612.119 -23.7782L592.545 -19.0164L593.006 -22.178L593 -22.153ZM597.104 18.5119L588.4 -13.3092C588.123 -14.326 588.618 -15.3462 589.521 -15.5577L591.45 -16.0305L617.416 -22.3561C618.308 -22.5718 619.274 -21.925 619.548 -20.8957L622.1 -11.5611C622.008 -11.3112 621.995 -11.0196 622.073 -10.7487L624.898 -0.438984C624.973 -0.155612 625.131 0.0903602 625.342 0.261393L628.255 10.9129C628.532 11.9297 628.037 12.9498 627.134 13.1613L599.227 19.9556C598.335 20.1713 597.369 19.5245 597.095 18.4952L597.104 18.5119ZM627.804 -2.49807L627.004 -2.30311L624.874 -10.0834L625.674 -10.2783L627.804 -2.49807ZM618.707 37.7736C618.707 37.7736 618.587 37.811 618.545 37.8359C618.493 37.8442 618.43 37.8483 618.367 37.8524L611.727 39.4743C611.57 39.5116 611.396 39.3948 611.348 39.2156L609.245 31.5395C608.577 29.1142 607.415 26.7924 605.873 24.8453L603.346 21.6514L623.527 16.732L622.958 20.6766C622.61 23.0842 622.778 25.6381 623.443 28.076L625.546 35.7521C625.594 35.9313 625.504 36.1145 625.347 36.1518L618.707 37.7736Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M805.162 30.4251L791.763 28.9131L791.705 31.2378L805.104 32.7498L805.162 30.4251Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M818.171 98.5759C819.078 97.7085 819.591 96.4833 819.619 95.0956L820.934 33.637C820.994 30.7826 818.952 28.2002 816.373 27.8692L778.89 23.047C777.648 22.8919 776.464 23.2687 775.557 24.1362C774.651 25.0036 774.138 26.2287 774.11 27.6165L772.795 89.075C772.77 90.4503 773.219 91.8094 774.085 92.9031C774.715 93.7098 775.517 94.2966 776.39 94.6133C776.7 94.7258 777.03 94.8051 777.356 94.8428L814.839 99.6651C816.081 99.8201 817.265 99.4433 818.171 98.5759ZM775.108 89.3767L775.233 83.4809L817.427 88.9107L817.303 94.8064C817.289 95.5003 817.017 96.1274 816.576 96.559C816.122 96.999 815.521 97.1978 814.897 97.1057L777.415 92.2834C776.115 92.1075 775.084 90.8059 775.111 89.3642L775.108 89.3767ZM818.621 33.3354L818.536 37.4445L776.342 32.0148L776.426 27.9056C776.453 26.4639 777.543 25.4346 778.846 25.5981L816.328 30.4203C817.631 30.5837 818.659 31.8978 818.632 33.3395L818.621 33.3354ZM818.477 40.0039L817.489 86.3388L775.294 80.9091L776.283 34.5742L818.477 40.0039Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M793.595 92.8574C793.895 93.2334 794.267 93.5021 794.678 93.6512C794.826 93.705 794.977 93.7465 795.134 93.7631C796.342 93.9213 797.349 92.9647 797.369 91.6231C797.4 90.2856 796.445 89.071 795.233 88.9252C794.648 88.8462 794.091 89.0313 793.67 89.4396C793.249 89.8478 793.001 90.4254 792.998 91.0653C792.981 91.7133 793.199 92.3534 793.606 92.8616L793.595 92.8574Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1157.75 160.62C1157.83 160.648 1157.91 160.676 1157.99 160.68L1164.57 161.43C1164.87 161.462 1165.15 161.367 1165.37 161.163C1165.59 160.956 1165.71 160.664 1165.71 160.328C1165.72 159.993 1165.6 159.681 1165.39 159.425C1165.18 159.169 1164.91 159.005 1164.6 158.972L1158.02 158.222C1157.4 158.154 1156.89 158.645 1156.89 159.328C1156.88 159.919 1157.26 160.455 1157.76 160.636L1157.75 160.62Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1133.66 182.247C1134.99 183.892 1136.63 185.074 1138.43 185.728C1139.13 185.981 1139.86 186.151 1140.59 186.242C1143.22 186.542 1145.69 185.691 1147.57 183.847C1149.45 181.992 1150.5 179.384 1150.53 176.469C1150.56 173.567 1149.56 170.71 1147.73 168.441C1145.89 166.173 1143.43 164.746 1140.8 164.446C1138.17 164.146 1135.7 164.998 1133.82 166.841C1131.95 168.685 1130.89 171.305 1130.86 174.219C1130.83 177.134 1131.83 179.979 1133.66 182.247ZM1146.09 170.05C1147.49 171.789 1148.26 173.978 1148.24 176.211C1148.21 178.432 1147.4 180.45 1145.97 181.864C1144.53 183.279 1142.62 183.937 1140.61 183.7C1138.59 183.462 1136.71 182.379 1135.3 180.639C1133.9 178.9 1133.13 176.711 1133.15 174.478C1133.2 169.875 1136.63 166.51 1140.78 166.989C1141.34 167.06 1141.9 167.18 1142.43 167.375C1143.81 167.876 1145.07 168.785 1146.09 170.05Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1164.32 163.129C1164.11 162.872 1163.83 162.719 1163.52 162.675L1158.74 162.128C1158.11 162.059 1157.61 162.552 1157.6 163.239C1157.59 163.833 1157.97 164.372 1158.48 164.553C1158.55 164.581 1158.63 164.609 1158.72 164.613L1163.5 165.16C1164.12 165.229 1164.63 164.736 1164.64 164.049C1164.64 163.712 1164.52 163.399 1164.31 163.141L1164.32 163.129Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1169.13 200.512C1170.27 199.398 1170.9 197.811 1170.93 196.056L1171.29 161.542C1171.3 159.782 1170.7 158.051 1169.59 156.68C1168.48 155.309 1166.98 154.45 1165.4 154.26L1156.3 153.216L1152.48 148.504C1151.52 147.305 1150.22 146.557 1148.84 146.4L1141.26 145.526C1141.19 145.514 1141.12 145.514 1141.04 145.526C1140.98 145.502 1140.91 145.477 1140.83 145.477L1133.26 144.603C1131.9 144.442 1130.55 144.908 1129.59 145.859L1125.69 149.685L1116.58 148.642C1113.3 148.261 1110.59 150.916 1110.55 154.562L1110.19 189.076C1110.16 192.222 1112.14 195.087 1114.79 196.049C1115.21 196.201 1115.64 196.304 1116.08 196.358L1164.9 201.951C1166.49 202.129 1168 201.614 1169.13 200.5L1169.13 200.512ZM1150.83 150.093L1153.04 152.831L1128.9 150.066L1131.16 147.85C1131.71 147.317 1132.46 147.059 1133.21 147.146L1140.79 148.02C1140.86 148.032 1140.93 148.032 1141.01 148.02C1141.07 148.045 1141.14 148.069 1141.22 148.069L1148.79 148.943C1149.56 149.038 1150.28 149.445 1150.82 150.118L1150.83 150.093ZM1112.47 189.345L1112.83 154.831C1112.85 152.584 1114.52 150.945 1116.55 151.177L1165.36 156.782C1165.64 156.815 1165.91 156.873 1166.17 156.967C1167.8 157.56 1169.02 159.329 1169.01 161.273L1168.65 195.787C1168.63 198.034 1166.95 199.669 1164.93 199.441L1116.12 193.836C1115.14 193.72 1114.21 193.198 1113.53 192.34C1112.84 191.495 1112.46 190.428 1112.48 189.333L1112.47 189.345Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M708.626 15.677L709.276 16.8204L709.9 17.9143L710.013 17.8484C710.3 17.659 710.654 17.614 710.973 17.7298L712.604 18.3215C713.242 18.5532 713.644 19.3127 713.494 20.0056L713.159 21.5523C713.081 21.9111 712.858 22.2037 712.542 22.356L712.415 22.4302L712.995 23.6148L713.258 24.1637L713.546 24.7622C713.851 24.6057 714.153 24.4617 714.472 24.3506L714.477 24.3259C714.934 24.1449 715.178 23.646 715.114 23.089C715.23 22.8374 715.318 22.6024 715.371 22.3549L715.706 20.8083C716.145 18.7791 714.976 16.5666 713.106 15.8881L711.476 15.2964C711.259 15.2178 711.023 15.1722 710.77 15.1471C710.385 14.8208 709.891 14.7749 709.506 15.022L709.384 15.0178L709.421 15.0715C709.166 15.2857 708.893 15.4669 708.62 15.6481L708.626 15.677Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M687.403 15.2242L687.395 15.2613L687.421 15.2572C687.649 15.5668 687.849 15.8929 688.046 16.2314L689.006 15.6054L689.937 14.9959L689.859 14.8473C689.65 14.5047 689.579 14.0922 689.654 13.7457L689.989 12.1992C690.139 11.5064 690.787 11.1276 691.425 11.3593L693.056 11.9509C693.375 12.0667 693.659 12.3434 693.829 12.6983L693.898 12.8304L694.871 12.3158L695.885 11.7765C695.722 11.4505 695.576 11.1038 695.429 10.7572L695.458 10.7407L695.401 10.72C695.274 10.394 695.07 10.1463 694.795 9.99337C694.607 9.8983 694.428 9.87335 694.229 9.88139C694.003 9.73265 693.783 9.6128 693.578 9.53833L691.948 8.94673C690.078 8.26824 688.191 9.37171 687.752 11.4007L687.417 12.9472C687.366 13.1823 687.347 13.4422 687.345 13.735C687.069 14.1555 687.074 14.7577 687.389 15.2324L687.403 15.2242Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M721.971 10.258C721.583 10.1173 721.188 10.0673 720.785 10.0545L719.528 7.67534C719.205 7.06403 718.463 6.79491 717.942 7.09984L716.674 7.84157C716.138 8.15474 715.972 8.9224 716.301 9.56262L717.578 11.9624C717.392 12.309 717.227 12.6762 717.138 13.0848C716.632 15.425 717.976 17.9693 720.133 18.7519C720.498 18.8844 720.879 18.9426 721.259 18.9471L722.726 21.7228C722.88 22.0326 723.139 22.2599 723.436 22.3676C723.732 22.4752 724.044 22.4549 724.301 22.2942L725.569 21.5524C725.825 21.3917 726.015 21.1401 726.085 20.8182C726.154 20.4963 726.107 20.1453 725.939 19.8438L724.489 17.1011C724.692 16.7339 724.86 16.3543 724.952 15.9333C725.458 13.5932 724.114 11.0488 721.957 10.2663L721.971 10.258ZM721.446 12.6849C722.37 13.0202 722.946 14.1107 722.729 15.1136C722.512 16.1165 721.582 16.6604 720.658 16.3251C719.734 15.9897 719.158 14.8992 719.375 13.8963C719.592 12.8934 720.522 12.3495 721.446 12.6849Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M725.476 -1.92622C716.907 -5.03565 708.298 -0.000112956 706.285 9.29866C706.006 10.5864 705.864 11.9238 705.856 13.2696C705.855 13.6163 705.978 13.955 706.192 14.2194C706.405 14.4838 706.691 14.641 706.993 14.6702C707.294 14.6995 707.585 14.6048 707.807 14.378C708.025 14.1636 708.143 13.8458 708.142 13.5114C708.144 12.3638 708.271 11.208 708.51 10.106C710.233 2.1445 717.603 -2.16579 724.939 0.49648C732.276 3.15875 736.842 11.7999 735.118 19.7614C733.395 27.723 726.025 32.0332 718.689 29.371C717.616 28.9818 716.584 28.4605 715.616 27.8155C715.347 27.6377 715.029 27.5754 714.743 27.6453C714.443 27.7234 714.215 27.9213 714.066 28.2143C713.778 28.8043 713.998 29.6054 714.571 29.9734C715.699 30.7301 716.908 31.3424 718.152 31.7937C726.721 34.9031 735.33 29.8676 737.343 20.5688C739.356 11.27 734.022 1.17494 725.453 -1.93449L725.476 -1.92622Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M715.836 38.4089C714.649 37.9783 713.431 37.6963 712.216 37.5629C711.915 37.5337 711.624 37.6283 711.403 37.8551C711.184 38.0696 711.066 38.3873 711.067 38.7217C711.066 39.0685 711.19 39.4071 711.403 39.6716C711.617 39.936 711.914 40.0973 712.204 40.1224C713.239 40.2308 714.281 40.4755 715.308 40.8481C722.645 43.5104 727.21 52.1514 725.487 60.1128C723.763 68.0743 716.394 72.3845 709.057 69.7223C701.721 67.06 697.155 58.419 698.879 50.4575C699.131 49.2937 699.505 48.1877 699.998 47.1644C700.133 46.8797 700.16 46.5289 700.059 46.1985C699.958 45.8682 699.762 45.5831 699.492 45.4053C699.223 45.2275 698.904 45.1652 698.619 45.2351C698.33 45.3174 698.091 45.5112 697.942 45.8041C697.363 46.9965 696.923 48.2923 696.631 49.6419C694.618 58.9406 699.952 69.0355 708.521 72.1449C717.089 75.2543 725.699 70.2189 727.712 60.9202C729.725 51.6215 724.391 41.5266 715.822 38.4172L715.836 38.4089Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M718.14 53.3138C718.209 52.9919 718.162 52.641 717.994 52.3395L717.208 50.8526C716.876 50.2248 716.169 49.9681 715.622 50.2771L713.283 51.6451C712.934 51.3846 712.576 51.1614 712.188 51.0206C710.032 50.2381 707.862 51.5072 707.355 53.8472C707.264 54.2682 707.255 54.7057 707.281 55.1557L705.238 56.3506C704.984 56.499 704.789 56.7753 704.722 57.0849C704.655 57.3944 704.7 57.7577 704.868 58.0592L705.654 59.5461C705.811 59.8435 706.067 60.0832 706.363 60.1908C706.66 60.2985 706.972 60.2782 707.228 60.1174L709.285 58.9143C709.615 59.154 709.964 59.3608 710.329 59.4933C712.485 60.2758 714.655 59.0067 715.162 56.6667C715.248 56.2705 715.265 55.8494 715.234 55.4242L717.601 54.0398C717.855 53.8914 718.05 53.6151 718.117 53.3055L718.14 53.3138ZM710.877 57.0749C709.953 56.7396 709.377 55.6492 709.594 54.6463C709.811 53.6434 710.741 53.0995 711.665 53.4349C712.589 53.7702 713.166 54.8606 712.948 55.8635C712.731 56.8663 711.801 57.4103 710.877 57.0749Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M684.397 32.5357L684.108 31.9363C683.803 32.093 683.501 32.2373 683.178 32.3609L683.173 32.3857C682.701 32.5752 682.466 33.0915 682.533 33.6369C682.419 33.8764 682.331 34.1118 682.278 34.3597L681.892 36.1441C681.452 38.1764 682.622 40.3922 684.495 41.0718L685.934 41.594C686.151 41.6727 686.387 41.7184 686.64 41.7434C686.764 41.8551 686.893 41.942 687.03 41.9918C687.087 42.0125 687.156 42.0373 687.215 42.0457C687.489 42.0914 687.738 42.0214 687.957 41.8605L688.015 41.8812L688 41.8358C688.002 41.8234 688.028 41.8193 688.042 41.811C688.301 41.5841 688.579 41.3778 688.867 41.188L688.201 40.0511L687.562 38.9638L687.449 39.0298C687.148 39.2278 686.791 39.2853 686.46 39.1651L685.021 38.643C684.381 38.4109 683.979 37.6503 684.13 36.9563L684.516 35.1719C684.594 34.8125 684.817 34.5194 685.134 34.3668L685.26 34.2926L684.971 33.6932L684.709 33.1434L684.42 32.544L684.397 32.5357Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M706.148 45.594L704.709 45.0719C704.378 44.9518 704.082 44.6705 703.918 44.2903L703.839 44.1415L702.857 44.6403L701.832 45.1639C702.002 45.5193 702.157 45.883 702.284 46.2632C702.42 46.66 702.722 46.9701 703.087 47.1027C703.224 47.1524 703.369 47.165 703.52 47.1527C703.746 47.3017 703.966 47.4217 704.195 47.5046L705.633 48.0266C707.506 48.7061 709.395 47.601 709.835 45.569L710.221 43.7848C710.272 43.5494 710.292 43.2891 710.293 42.9958C710.555 42.583 710.565 42.0253 710.284 41.5623L710.28 41.4673L710.249 41.4962C710.249 41.4962 710.24 41.4797 710.231 41.4631C710.014 41.1572 709.823 40.8472 709.634 40.5247C709.634 40.5247 709.616 40.4917 709.605 40.4875L708.675 41.0856L707.712 41.7248L707.793 41.8612C708.002 42.2044 708.075 42.6051 707.997 42.9645L707.611 44.7487C707.461 45.4425 706.813 45.8219 706.173 45.5899L706.148 45.594Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M676.088 48.2477C676.465 48.3843 676.857 48.4466 677.249 48.4553L678.498 50.8715C678.655 51.1689 678.911 51.4085 679.208 51.5162C679.505 51.6238 679.817 51.6035 680.073 51.4428L681.341 50.7011C681.597 50.5404 681.787 50.2888 681.857 49.9669C681.926 49.645 681.879 49.2941 681.711 48.9926L680.445 46.597C680.648 46.2298 680.816 45.8502 680.907 45.4293C681.414 43.0893 680.069 40.545 677.913 39.7625C677.525 39.6218 677.13 39.5718 676.726 39.559L675.277 36.8165C674.946 36.1887 674.238 35.932 673.691 36.241L672.423 36.9827C672.158 37.1269 671.977 37.395 671.908 37.7169C671.838 38.0388 671.885 38.3898 672.054 38.6913L673.52 41.4668C673.334 41.8134 673.169 42.1806 673.083 42.5768C672.576 44.9168 673.921 47.461 676.077 48.2435L676.088 48.2477ZM676.614 45.821C675.69 45.4856 675.113 44.3952 675.331 43.3924C675.548 42.3895 676.478 41.8456 677.402 42.181C678.326 42.5163 678.902 43.6067 678.685 44.6096C678.468 45.6124 677.538 46.1563 676.614 45.821Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M680.011 6.1882L680.797 7.67518C680.965 7.97671 681.21 8.21228 681.507 8.31993C681.803 8.42758 682.115 8.40725 682.371 8.24653L684.739 6.86201C685.068 7.10179 685.415 7.32095 685.78 7.45344C687.936 8.23595 690.106 6.9668 690.613 4.62669C690.701 4.2181 690.721 3.78466 690.69 3.35943L692.753 2.1851C693.289 1.87194 693.455 1.10428 693.126 0.464067L692.34 -1.02291C692.183 -1.32031 691.925 -1.54762 691.628 -1.65526C691.331 -1.76291 691.019 -1.74261 690.766 -1.59426L688.723 -0.399278C688.373 -0.659723 688.015 -0.883031 687.627 -1.0238C685.471 -1.80632 683.301 -0.537157 682.794 1.80296C682.703 2.22393 682.694 2.6615 682.72 3.11149L680.381 4.47955C679.846 4.79272 679.68 5.56037 680.009 6.20058L680.011 6.1882ZM687.102 1.40299C688.026 1.73836 688.602 2.82879 688.385 3.8317C688.168 4.83461 687.238 5.37853 686.314 5.04317C685.39 4.7078 684.813 3.61736 685.031 2.61445C685.248 1.61155 686.178 1.06763 687.102 1.40299Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M690.32 -13.4858C681.751 -16.5952 673.142 -11.5597 671.129 -2.26091C669.116 7.03786 674.449 17.133 683.018 20.2424C684.262 20.6937 685.541 20.984 686.808 21.0969C687.437 21.1512 687.955 20.6316 687.946 19.9339C687.947 19.5871 687.821 19.2609 687.596 18.9923C687.383 18.7278 687.083 18.5789 686.781 18.5497C685.696 18.4495 684.605 18.2006 683.532 17.8114C676.196 15.1491 671.63 6.50799 673.354 -1.45354C675.077 -9.41507 682.446 -13.7254 689.783 -11.0631C697.12 -8.40082 701.685 0.240324 699.962 8.20186C699.723 9.30384 699.368 10.3768 698.909 11.3588C698.774 11.6435 698.747 11.9944 698.848 12.3248C698.949 12.6551 699.145 12.9402 699.415 13.118C699.684 13.2958 700.002 13.3581 700.291 13.2758C700.591 13.1977 700.821 12.9874 700.957 12.7027C701.49 11.5474 701.905 10.3093 702.184 9.02161C704.197 -0.277161 698.863 -10.3722 690.294 -13.4817L690.32 -13.4858Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M692.641 44.2505C692.425 43.9984 692.139 43.8413 691.826 43.8079C691.525 43.7787 691.231 43.8857 691.024 44.1043C690.805 44.3187 690.687 44.6365 690.689 44.9708C690.698 46.1763 690.575 47.3733 690.323 48.5372C688.599 56.4985 681.23 60.8087 673.893 58.1465C666.557 55.4843 661.991 46.8433 663.715 38.882C665.438 30.9206 672.808 26.6105 680.144 29.2727C681.171 29.6453 682.16 30.1376 683.087 30.7413C683.356 30.9191 683.675 30.9814 683.964 30.8991C684.252 30.8168 684.494 30.6107 684.629 30.326C684.908 29.7195 684.671 28.939 684.113 28.5627C683.022 27.8598 681.867 27.2806 680.681 26.85C672.112 23.7407 663.503 28.7761 661.49 38.0746C659.477 47.3732 664.811 57.4681 673.38 60.5774C681.948 63.6868 690.557 58.6514 692.57 49.3528C692.863 48.0032 693.006 46.5998 692.991 45.1921C692.992 44.8453 692.866 44.5191 692.641 44.2505Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1185.22 225.046C1185.38 225.375 1185.65 225.62 1185.96 225.733L1235.01 243.364C1235.32 243.477 1235.65 243.435 1235.92 243.265C1236.18 243.091 1236.37 242.796 1236.42 242.451L1243.8 188.894C1243.89 188.242 1243.5 187.577 1242.92 187.364L1233.99 184.15L1234.72 180.773C1235.37 177.66 1234.88 174.352 1233.32 171.42C1231.77 168.505 1229.36 166.338 1226.51 165.304L1226.47 165.291C1220.56 163.174 1214.64 166.659 1213.28 173.074L1212.54 176.452L1201.42 172.454C1200.83 172.242 1200.24 172.565 1200.06 173.184L1185.13 224.032C1185.03 224.36 1185.08 224.738 1185.23 225.063L1185.22 225.046ZM1215.52 173.874C1216.05 171.431 1217.42 169.442 1219.38 168.272C1221.36 167.106 1223.68 166.913 1225.94 167.735L1225.97 167.743C1228.21 168.556 1230.12 170.27 1231.35 172.574C1232.58 174.89 1232.97 177.504 1232.44 179.96L1231.71 183.338L1214.8 177.256L1215.53 173.878L1215.52 173.874ZM1210.84 184.383L1208.9 183.679C1208.6 183.571 1208.28 183.604 1208.03 183.753C1207.77 183.915 1207.58 184.168 1207.51 184.492C1207.44 184.816 1207.48 185.169 1207.65 185.473C1207.82 185.789 1208.07 186.014 1208.37 186.122L1214.74 188.406C1215.36 188.631 1215.98 188.266 1216.13 187.593C1216.28 186.92 1215.89 186.188 1215.27 185.963L1213.1 185.175L1214.27 179.699L1231.19 185.785L1230 191.269L1228.01 190.544C1227.39 190.319 1226.76 190.684 1226.62 191.357C1226.47 192.03 1226.86 192.762 1227.48 192.987L1233.85 195.271C1234.15 195.38 1234.46 195.359 1234.72 195.197C1234.98 195.036 1235.17 194.782 1235.24 194.458C1235.38 193.785 1235 193.053 1234.38 192.828L1232.27 192.066L1233.45 186.589L1241.33 189.424L1234.29 240.471L1187.69 223.723L1201.91 175.256L1212 178.891L1210.82 184.375L1210.84 184.383Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M910.401 91.8382L900.711 87.0802C900.425 86.9379 900.111 86.9294 899.843 87.0428C899.575 87.1561 899.365 87.3953 899.262 87.6995C899.16 88.0038 899.181 88.3528 899.309 88.6613C899.436 88.9698 899.672 89.2257 899.957 89.368L909.647 94.126C909.746 94.1748 909.834 94.2723 909.883 94.3819C909.933 94.4915 909.94 94.6254 909.905 94.7309L907.937 100.702C907.864 100.925 907.632 101.038 907.415 100.921L905.899 100.176C904.382 99.4321 902.716 99.8808 901.831 101.268L890.645 118.692C890.238 119.333 889.464 119.539 888.772 119.198L853.974 102.134C853.282 101.792 852.836 100.988 852.902 100.185L854.731 78.2016C854.874 76.4812 853.937 74.7516 852.458 74.0075L852.074 73.8163C851.865 73.7147 851.755 73.4386 851.827 73.2155L853.801 67.2201C853.836 67.1146 853.916 67.0255 854.011 66.9809C854.106 66.9364 854.213 66.9487 854.326 66.9894L863.84 71.6579C864.126 71.8002 864.44 71.8086 864.708 71.6953C864.976 71.582 865.186 71.3428 865.288 71.0385C865.499 70.4057 865.187 69.6628 864.594 69.37L855.079 64.7015C853.695 64.0184 852.155 64.67 851.661 66.1587L849.687 72.1541C849.198 73.6185 849.922 75.3763 851.289 76.0798L851.673 76.2709C852.187 76.5352 852.518 77.1402 852.472 77.7407L850.643 99.7241C850.477 101.66 851.54 103.592 853.223 104.41L888.021 121.473C888.154 121.534 888.287 121.595 888.422 121.644C889.989 122.21 891.637 121.676 892.54 120.269L903.725 102.844C904.036 102.366 904.617 102.208 905.157 102.468L906.673 103.212C908.056 103.896 909.597 103.244 910.091 101.755L912.059 95.7842C912.553 94.2954 911.818 92.5335 910.423 91.8463L910.401 91.8382Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M883.081 98.0161C882.791 97.83 882.472 97.7706 882.177 97.842C881.878 97.9262 881.631 98.1244 881.488 98.4282L876.812 108.089C876.672 108.38 876.645 108.739 876.749 109.077C876.853 109.415 877.057 109.706 877.347 109.893L877.483 109.969C877.483 109.969 877.566 109.998 877.601 110.011C878.133 110.202 878.691 109.978 878.931 109.464L883.606 99.8028C883.747 99.5116 883.774 99.1527 883.67 98.8148C883.566 98.4769 883.362 98.1853 883.084 98.0034L883.081 98.0161Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M871.801 92.6076C871.485 92.4966 871.163 92.5345 870.878 92.696C870.605 92.8618 870.413 93.1384 870.351 93.4747L868.146 104.461C868.018 105.091 868.363 105.777 868.943 106.05L869.052 106.089L869.089 106.102C869.747 106.319 870.398 105.928 870.539 105.235L872.744 94.2478C872.818 93.9157 872.756 93.5495 872.577 93.2385C872.397 92.9275 872.119 92.7058 871.804 92.5948L871.801 92.6076Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M866.461 89.9923C866.143 89.907 865.817 89.9704 865.568 90.157C865.308 90.3394 865.138 90.6366 865.1 90.9806L863.545 103.086C863.463 103.689 863.803 104.318 864.343 104.577L864.523 104.641L864.583 104.663C864.901 104.748 865.227 104.684 865.476 104.498C865.737 104.315 865.906 104.018 865.944 103.674L867.499 91.5694C867.589 90.8728 867.125 90.1587 866.473 89.9966L866.461 89.9923Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M876.397 95.141C876.112 95.2595 875.888 95.5097 875.779 95.8278L872.287 106.243C872.063 106.904 872.395 107.681 873.025 107.988C873.073 108.005 873.109 108.017 873.145 108.03C873.732 108.239 874.352 107.951 874.555 107.323L878.048 96.9081C878.272 96.2463 877.939 95.4694 877.309 95.1632C877.006 95.0143 876.672 95.0055 876.387 95.124L876.397 95.141Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M892.102 84.0178C892.102 84.0178 892.18 84.0449 892.224 84.0604C892.768 84.2504 893.342 83.9881 893.528 83.4279C893.629 83.1381 893.608 82.8058 893.483 82.5119C893.357 82.218 893.125 81.9743 892.844 81.8387L873.6 72.7056C873.319 72.57 873.009 72.562 872.746 72.6699C872.482 72.7779 872.275 73.0057 872.174 73.2954C871.966 73.8981 872.274 74.6057 872.858 74.8846L892.102 84.0178Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M891.789 97.0351C892.332 97.2243 892.906 96.9632 893.092 96.4052C893.193 96.1167 893.172 95.7856 893.046 95.4929C892.921 95.2003 892.689 94.9576 892.408 94.8226L867.501 83.0535C867.22 82.9185 866.911 82.9104 866.648 83.0179C866.384 83.1254 866.177 83.3523 866.076 83.6409C865.975 83.9295 865.996 84.2605 866.122 84.5532C866.247 84.8459 866.479 85.0886 866.76 85.2236L891.664 97.0042C891.664 97.0042 891.742 97.0313 891.775 97.0428L891.789 97.0351Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M865.275 72.1778C864.682 71.8851 864.038 72.1643 863.827 72.7968C863.617 73.4294 863.929 74.172 864.522 74.4646L870.563 77.432C870.563 77.432 870.642 77.4605 870.687 77.4768C870.935 77.5663 871.204 77.5585 871.433 77.4573C871.701 77.344 871.911 77.1049 872.013 76.8008C872.116 76.4967 872.095 76.1479 871.967 75.8395C871.84 75.5311 871.604 75.2753 871.319 75.133L869.549 74.2712L870.561 71.1856C873.085 63.5546 880.94 60.1963 888.093 63.6962C891.554 65.3913 894.334 68.4282 895.923 72.2427C897.512 76.0572 897.717 80.1987 896.499 83.8926L895.487 86.9782L893.268 85.8888C892.983 85.7466 892.669 85.7381 892.401 85.8514C892.133 85.9647 891.923 86.2038 891.821 86.5079C891.718 86.812 891.739 87.1608 891.867 87.4693C891.994 87.7777 892.23 88.0335 892.515 88.1757L898.567 91.1472C898.567 91.1472 898.646 91.1756 898.68 91.1878C899.233 91.3872 899.815 91.112 900.007 90.5119C900.217 89.8794 899.905 89.1367 899.312 88.8441L897.621 88.0108L898.633 84.9251C901.565 76.0371 897.176 65.4784 888.849 61.3972C880.522 57.316 871.355 61.2245 868.424 70.1125L867.412 73.1981L865.269 72.1494L865.275 72.1778Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M888.29 100.359C887.723 99.9376 887.012 100.063 886.672 100.636L880.932 110.575C880.769 110.857 880.718 111.207 880.795 111.548C880.873 111.889 881.061 112.189 881.332 112.395L881.556 112.53C881.556 112.53 881.638 112.56 881.673 112.573C882.166 112.75 882.687 112.569 882.953 112.106L888.693 102.167C888.856 101.885 888.907 101.535 888.829 101.194C888.752 100.853 888.564 100.553 888.293 100.347L888.29 100.359Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M988.509 105.516C986.696 105.279 986.827 102.142 988.628 102.374C990.44 102.611 990.31 105.748 988.509 105.516ZM988.509 105.516C990.31 105.748 990.443 102.598 988.628 102.374C986.827 102.142 986.694 105.292 988.509 105.516ZM992.476 108.874L992.954 96.6881C992.969 96.3414 992.732 96.0269 992.422 95.9848L944.44 89.801C944.13 89.7589 943.867 90.0044 943.852 90.3511L943.374 102.537C943.359 102.884 943.596 103.198 943.905 103.24L961.236 105.473C961.545 105.515 961.808 105.27 961.823 104.923C961.839 104.576 961.602 104.262 961.292 104.22L944.522 102.063L944.943 91.131L991.806 97.1616L991.385 108.094L973.447 105.781C973.137 105.739 972.874 105.985 972.859 106.331C972.844 106.678 973.081 106.992 973.39 107.035L991.891 109.411C992.2 109.454 992.463 109.208 992.479 108.861L992.476 108.874ZM985.969 152.221L987.64 109.218C987.655 108.871 987.418 108.556 987.109 108.514C986.799 108.472 986.536 108.718 986.521 109.064L984.878 151.441L947.616 146.649L949.258 104.272C949.274 103.925 949.037 103.611 948.727 103.569C948.418 103.527 948.155 103.772 948.139 104.119L946.468 147.122C946.453 147.469 946.69 147.783 946.999 147.825L985.381 152.771C985.69 152.813 985.953 152.568 985.969 152.221ZM972.279 150.223L974.437 94.5495C974.453 94.2027 974.216 93.8883 973.906 93.8462L961.967 92.3068C961.658 92.2647 961.395 92.5101 961.379 92.8569L959.221 148.53C959.206 148.877 959.443 149.192 959.752 149.234L971.691 150.773C972.001 150.815 972.264 150.57 972.279 150.223ZM962.47 93.6368L973.287 95.0355L971.174 149.452L960.357 148.053L962.47 93.6368ZM967.746 93.3545C968.05 93.3674 968.296 93.0888 968.286 92.7465C968.06 86.2314 965.728 83.4125 963.815 82.1918C961.298 80.5945 958.447 81.0598 956.862 82.1776C953.602 84.4893 957.085 91.198 957.231 91.4802C957.394 91.7955 957.738 91.904 958.005 91.7545C958.274 91.5926 958.346 91.2117 958.194 90.9004C958.159 90.834 955.146 84.9421 957.506 83.2594C958.861 82.2906 961.296 81.9892 963.317 83.2753C964.963 84.3197 966.964 86.8044 967.167 92.7019C967.18 93.0316 967.411 93.3168 967.698 93.3509C967.709 93.3549 967.732 93.363 967.744 93.367L967.746 93.3545ZM969.587 93.0185C970.242 87.2357 972.416 85.284 974.122 84.67C976.217 83.9092 978.6 84.8359 979.869 86.1397C982.08 88.4006 978.637 93.4787 978.603 93.5209C978.422 93.782 978.467 94.1907 978.723 94.4172C978.969 94.6396 979.329 94.6185 979.51 94.3573C979.673 94.1173 983.647 88.3603 980.598 85.233C979.117 83.7189 976.341 82.5172 973.717 83.4557C971.73 84.1734 969.208 86.3675 968.468 92.7568C968.429 93.0955 968.649 93.431 968.954 93.4982C968.965 93.5022 968.988 93.5103 968.999 93.5143C969.286 93.5484 969.54 93.3406 969.576 93.0145L969.587 93.0185ZM961.108 127.93L961.464 118.79C961.479 118.443 961.242 118.129 960.933 118.087L948.252 116.46C947.943 116.418 947.68 116.664 947.665 117.01L947.309 126.151C947.293 126.498 947.531 126.812 947.84 126.854L960.52 128.48C960.83 128.522 961.093 128.277 961.108 127.93ZM948.755 117.79L960.314 119.276L960.003 127.159L948.445 125.673L948.755 117.79ZM986.775 131.237L987.131 122.097C987.147 121.75 986.909 121.436 986.6 121.394L973.181 119.668C972.872 119.626 972.609 119.871 972.593 120.218L972.238 129.358C972.222 129.705 972.459 130.02 972.769 130.062L986.188 131.787C986.497 131.83 986.76 131.584 986.775 131.237ZM973.695 121.002L985.992 122.587L985.682 130.47L973.385 128.885L973.695 121.002ZM993.033 108.963L993.511 96.7773C993.541 96.0838 993.056 95.4509 992.434 95.3793L944.451 89.1954C943.832 89.1112 943.304 89.6147 943.284 90.3122L942.806 102.498C942.775 103.192 943.261 103.824 943.883 103.896L961.213 106.129C961.832 106.213 962.361 105.709 962.38 105.012C962.411 104.318 961.926 103.686 961.304 103.614L945.095 101.522L945.471 91.8468L991.213 97.7368L990.837 107.412L973.458 105.176C972.839 105.091 972.31 105.595 972.291 106.292C972.26 106.986 972.746 107.619 973.368 107.69L991.868 110.067C992.487 110.151 993.016 109.648 993.035 108.951L993.033 108.963ZM991.351 108.746C991.661 108.788 991.924 108.543 991.939 108.196L992.36 97.2633C992.376 96.9166 992.139 96.6022 991.829 96.5601L944.966 90.5294C944.656 90.4873 944.393 90.7327 944.378 91.0795L943.956 102.012C943.941 102.359 944.178 102.673 944.488 102.715L943.928 102.639L944.406 90.4528L992.389 96.6367L991.911 108.822L973.41 106.446L991.348 108.758L991.351 108.746ZM986.537 152.314L988.208 109.311C988.239 108.617 987.754 107.984 987.132 107.913C986.512 107.829 985.984 108.332 985.964 109.03L984.35 150.779L948.209 146.128L949.824 104.378C949.855 103.684 949.369 103.052 948.747 102.98C948.128 102.896 947.599 103.399 947.58 104.097L945.909 147.1C945.878 147.793 946.363 148.426 946.985 148.498L985.367 153.443C985.986 153.528 986.515 153.024 986.534 152.327L986.537 152.314ZM947.593 147.305L984.855 152.097C985.165 152.139 985.428 151.893 985.443 151.547L987.086 109.17L985.415 152.173L947.033 147.228L947.062 146.601C947.046 146.948 947.283 147.262 947.593 147.305ZM972.847 150.316L975.006 94.6426C975.036 93.9491 974.551 93.3163 973.929 93.2446L961.99 91.7053C961.371 91.6211 960.842 92.1245 960.823 92.822L958.664 148.495C958.634 149.189 959.119 149.822 959.741 149.893L971.68 151.433C972.299 151.517 972.828 151.014 972.847 150.316ZM960.346 148.713L971.163 150.111C971.472 150.154 971.735 149.908 971.751 149.561L973.864 95.1453C973.879 94.7985 973.642 94.4841 973.333 94.442L973.892 94.5186L971.734 150.192L959.795 148.653L959.823 148.026C959.808 148.373 960.045 148.687 960.355 148.729L960.346 148.713ZM963.019 94.3732L972.716 95.6188L970.649 148.777L960.951 147.532L963.019 94.3732ZM962.504 93.0393C962.195 92.9972 961.932 93.2426 961.916 93.5893L961.945 92.9627L962.504 93.0393ZM967.783 94.0179C968.087 94.0308 968.359 93.9106 968.571 93.6741C968.769 93.4462 968.875 93.1317 968.865 92.7895C968.624 85.9572 966.132 82.9732 964.079 81.6624C961.348 79.9216 958.265 80.4399 956.559 81.6636C952.875 84.2854 956.612 91.5045 956.778 91.8073C957.108 92.4253 957.802 92.6715 958.328 92.3435C958.583 92.19 958.763 91.9289 958.836 91.6023C958.908 91.2757 958.861 90.9339 958.704 90.6478C957.973 89.2371 956.267 84.9741 957.866 83.8479C959.089 82.981 961.282 82.7159 963.101 83.8625C964.607 84.8168 966.438 87.1324 966.636 92.7168C966.662 93.3762 967.127 93.9341 967.71 94.0188C967.721 94.0228 967.792 94.0345 967.806 94.026L967.783 94.0179ZM967.744 92.7574C967.57 87.7782 966.133 85.0735 964.661 83.6303C966.141 85.0901 967.57 87.7782 967.755 92.7614L967.744 92.7574ZM963.47 82.693C961.372 81.4203 958.884 81.6891 957.387 82.6346C958.329 82.0342 959.682 81.6876 961.113 81.8703C961.889 81.9693 962.702 82.2306 963.468 82.7055L963.47 82.693ZM970.167 93.17C970.792 87.6882 972.791 85.8639 974.35 85.306C976.243 84.6229 978.39 85.4523 979.539 86.6323C981.04 88.167 979.013 91.9458 978.181 93.1545C977.806 93.6852 977.912 94.4815 978.411 94.9429C978.91 95.4044 979.611 95.3415 979.986 94.8107C981.653 92.4352 983.731 87.6452 980.982 84.8274C979.382 83.1895 976.37 81.8905 973.532 82.9027C971.401 83.6639 968.703 85.9854 967.931 92.6883C967.895 93.0144 967.968 93.3517 968.162 93.6374C968.345 93.9191 968.61 94.1079 968.903 94.1711C968.925 94.1791 968.985 94.1868 969.008 94.1948C969.593 94.2669 970.096 93.8223 970.176 93.1866L970.167 93.17ZM974.114 84.0438C976.334 83.3274 978.657 84.2465 980.025 85.4906C979.127 84.6707 977.821 84.0313 976.438 83.8522C975.674 83.7572 974.879 83.8005 974.114 84.0438ZM961.699 128.031L962.055 118.891C962.086 118.198 961.6 117.565 960.978 117.493L948.298 115.867C947.679 115.783 947.15 116.286 947.131 116.984L946.775 126.124C946.744 126.818 947.23 127.45 947.852 127.522L960.532 129.148C961.151 129.232 961.68 128.729 961.699 128.031ZM948.459 126.329L960.018 127.814C960.327 127.856 960.59 127.611 960.606 127.264L960.916 119.381C960.931 119.034 960.694 118.72 960.385 118.678L960.944 118.755L960.589 127.895L947.908 126.269L947.937 125.642C947.921 125.989 948.158 126.303 948.468 126.345L948.459 126.329ZM949.329 118.522L959.766 119.867L959.512 126.497L949.076 125.152L949.329 118.522ZM948.815 117.188C948.505 117.146 948.243 117.392 948.227 117.738L948.255 117.112L948.815 117.188ZM987.378 131.343L987.733 122.202C987.764 121.509 987.279 120.876 986.657 120.804L973.238 119.079C972.619 118.994 972.09 119.498 972.071 120.195L971.715 129.336C971.684 130.029 972.17 130.662 972.792 130.734L986.21 132.459C986.83 132.544 987.358 132.04 987.378 131.343ZM973.4 129.54L985.696 131.125C986.006 131.168 986.269 130.922 986.284 130.575L986.594 122.692C986.61 122.346 986.373 122.031 986.063 121.989L986.623 122.066L986.267 131.206L972.848 129.48L972.877 128.854C972.861 129.2 973.098 129.515 973.408 129.557L973.4 129.54ZM974.269 121.734L985.433 123.174L985.179 129.804L974.016 128.364L974.269 121.734ZM973.755 120.4C973.445 120.358 973.183 120.603 973.167 120.95L973.195 120.323L973.755 120.4Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M664.366 106.898L664.454 101.708C664.538 97.087 662.476 92.749 659.085 90.3957L655.411 87.8379L659.683 87.8924C663.623 87.9489 667.307 85.4996 669.283 81.5009L671.507 77.0131L671.418 82.2029C671.335 86.8239 673.397 91.1619 676.788 93.5152L680.462 96.073L676.19 96.0185C672.25 95.962 668.566 98.4113 666.59 102.41L664.366 106.898ZM662.653 90.2187C664.573 92.3669 665.89 95.1519 666.447 98.1879C668.268 95.9334 670.635 94.3735 673.231 93.6958C671.31 91.5476 669.993 88.7626 669.426 85.723C667.605 87.9775 665.238 89.5374 662.653 90.2187Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M350.986 -1.85509L351.075 -7.04492C351.158 -11.6659 349.096 -16.0039 345.705 -18.3572L342.031 -20.915L346.303 -20.8605C350.243 -20.804 353.927 -23.2533 355.903 -27.252L358.127 -31.7399L358.039 -26.55C357.955 -21.9291 360.017 -17.591 363.408 -15.2378L367.082 -12.6799L362.81 -12.7345C358.87 -12.7909 355.186 -10.3416 353.21 -6.34298L350.986 -1.85509ZM349.273 -18.5342C351.194 -16.386 352.511 -13.601 353.067 -10.565C354.888 -12.8195 357.255 -14.3794 359.84 -15.0607C357.92 -17.2089 356.602 -19.9939 356.046 -23.0299C354.225 -20.7754 351.858 -19.2155 349.273 -18.5342Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1075.85 109.198L1075.94 104.008C1076.02 99.3868 1073.96 95.0488 1070.57 92.6955L1066.89 90.1377L1071.16 90.1922C1075.1 90.2487 1078.79 87.7994 1080.76 83.8007L1082.99 79.3129L1082.9 84.5027C1082.82 89.1237 1084.88 93.4617 1088.27 95.815L1091.94 98.3728L1087.67 98.3183C1083.73 98.2619 1080.05 100.711 1078.07 104.71L1075.85 109.198ZM1074.13 92.5185C1076.05 94.6668 1077.37 97.4517 1077.93 100.488C1079.75 98.2332 1082.12 96.6733 1084.7 95.992C1082.78 93.8438 1081.46 91.0588 1080.91 88.0228C1079.09 90.2773 1076.72 91.8372 1074.13 92.5185Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M860.102 49.5092L860.191 44.3194C860.274 39.6984 858.212 35.3604 854.821 33.0071L851.147 30.4492L855.42 30.5038C859.359 30.5602 863.043 28.1109 865.019 24.1123L867.243 19.6244L867.155 24.8142C867.071 29.4352 869.133 33.7732 872.524 36.1265L876.198 38.6844L871.926 38.6298C867.986 38.5734 864.302 41.0226 862.326 45.0213L860.102 49.5092ZM858.39 32.83C860.31 34.9783 861.627 37.7632 862.183 40.7992C864.004 38.5448 866.371 36.9848 868.956 36.3035C867.036 34.1553 865.719 31.3704 865.162 28.3343C863.341 30.5888 860.974 32.1488 858.39 32.83Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1085.93 223.949L1086.02 218.759C1086.1 214.138 1084.04 209.8 1080.65 207.447L1076.97 204.889L1081.24 204.943C1085.18 205 1088.87 202.55 1090.84 198.552L1093.07 194.064L1092.98 199.254C1092.9 203.875 1094.96 208.213 1098.35 210.566L1102.02 213.124L1097.75 213.069C1093.81 213.013 1090.13 215.462 1088.15 219.461L1085.93 223.949ZM1084.2 207.266C1086.12 209.414 1087.44 212.199 1088 215.235C1089.82 212.981 1092.19 211.421 1094.77 210.739C1092.85 208.591 1091.53 205.806 1090.98 202.77C1089.16 205.025 1086.79 206.585 1084.2 207.266Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M918.64 182.999C915.206 181.87 913.182 177.67 914.147 173.631C915.112 169.592 918.691 167.233 922.136 168.366C925.581 169.498 927.594 173.695 926.629 177.734C925.664 181.773 922.085 184.131 918.64 182.999ZM921.517 170.96C919.293 170.229 916.968 171.761 916.345 174.367C915.723 176.974 917.019 179.696 919.253 180.431C921.488 181.165 923.798 179.643 924.424 177.023C925.05 174.404 923.751 171.694 921.517 170.96Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M747.014 107.696C743.58 106.567 741.556 102.367 742.521 98.3281C743.486 94.2892 747.065 91.9307 750.51 93.0633C753.955 94.1958 755.968 98.3923 755.003 102.431C754.038 106.47 750.459 108.828 747.014 107.696ZM749.891 95.6569C747.667 94.926 745.342 96.4581 744.719 99.0646C744.097 101.671 745.393 104.394 747.627 105.128C749.862 105.863 752.176 104.327 752.798 101.72C753.421 99.1139 752.114 96.3878 749.891 95.6569Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1198.34 150.148C1194.91 149.019 1192.89 144.819 1193.85 140.78C1194.82 136.741 1198.4 134.383 1201.84 135.515C1205.29 136.648 1207.3 140.844 1206.33 144.883C1205.37 148.922 1201.79 151.281 1198.34 150.148ZM1201.22 138.109C1199 137.378 1196.67 138.91 1196.05 141.517C1195.43 144.123 1196.72 146.846 1198.96 147.58C1201.19 148.315 1203.51 146.779 1204.13 144.173C1204.75 141.566 1203.45 138.844 1201.22 138.109Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1211.27 272.834C1207.83 271.705 1205.81 267.505 1206.77 263.466C1207.74 259.427 1211.32 257.068 1214.76 258.201C1218.21 259.333 1220.22 263.53 1219.25 267.569C1218.29 271.608 1214.71 273.966 1211.27 272.834ZM1214.14 260.795C1211.92 260.064 1209.59 261.596 1208.97 264.202C1208.35 266.809 1209.64 269.531 1211.88 270.266C1214.11 271 1216.43 269.465 1217.05 266.858C1217.67 264.252 1216.38 261.529 1214.14 260.795Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M492.23 23.3395C488.796 22.2106 486.773 18.0105 487.738 13.9716C488.703 9.93279 492.282 7.57431 495.727 8.70681C499.172 9.83932 501.185 14.0359 500.22 18.0747C499.255 22.1135 495.676 24.472 492.23 23.3395ZM495.107 11.3004C492.884 10.5696 490.559 12.1016 489.936 14.7082C489.313 17.3147 490.61 20.0372 492.844 20.7717C495.078 21.5062 497.389 19.9834 498.015 17.364C498.641 14.7445 497.331 12.0313 495.107 11.3004Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M582.487 55.0531L580.614 56.2607L589.094 73.7969L590.966 72.5892L582.487 55.0531Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M592.581 58.3585L577.798 67.9805L579.001 70.4911L593.784 60.8691L592.581 58.3585Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M932.916 49.1556L931.044 50.3633L939.523 67.8994L941.396 66.6918L932.916 49.1556Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M943.01 52.461L928.228 62.083L929.43 64.5936L944.213 54.9716L943.01 52.461Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1152.81 229.313L1150.94 230.521L1159.42 248.057L1161.29 246.849L1152.81 229.313Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1162.9 232.572L1148.12 242.194L1149.32 244.705L1164.1 235.083L1162.9 232.572Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M423.871 -13.0054L421.463 -13.8301L417.069 5.32112L419.478 6.14578L423.871 -13.0054Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M428.99 -2.2022L412.492 -7.83203L411.951 -5.48272L428.449 0.147106L428.99 -2.2022Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M832.045 117.001L829.637 116.177L825.243 135.328L827.652 136.153L832.045 117.001Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M837.164 127.805L820.666 122.175L820.125 124.524L836.623 130.154L837.164 127.805Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1003 181.547L1000.59 180.723L996.199 199.874L998.608 200.699L1003 181.547Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1008.12 192.351L991.622 186.721L991.081 189.07L1007.58 194.7L1008.12 192.351Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1151.78 90.5893L1149.38 89.7646L1144.98 108.916L1147.39 109.741L1151.78 90.5893Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
        <path
          d="M1156.9 101.393L1140.41 95.7627L1139.86 98.112L1156.36 103.742L1156.9 101.393Z"
          fill={theme.palette.primary.main}
          fillOpacity="0.1"
        />
      </g>
    </svg>
  );
};

export default HeroBgSvg;
